/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MathUtils;
import dr.math.matrixAlgebra.ReadableMatrix;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.WrappedVector;

public interface MaximumEigenvalue {
    public double find(double[][] var1);

    public static class PowerMethod
    implements MaximumEigenvalue {
        private final int numIterations;
        private final double err;

        public PowerMethod(int n, double d) {
            this.numIterations = n;
            this.err = d;
        }

        @Override
        public double find(double[][] dArray) {
            ReadableVector.Scale scale;
            ReadableVector.Sum sum;
            WrappedMatrix.ArrayOfArray arrayOfArray = new WrappedMatrix.ArrayOfArray(dArray);
            WrappedVector wrappedVector = PowerMethod.getInitialGuess(dArray.length);
            double d = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.numIterations && !(ReadableVector.Utils.norm(sum = new ReadableVector.Sum(wrappedVector = ReadableMatrix.Utils.product((ReadableMatrix)arrayOfArray, scale = new ReadableVector.Scale(1.0 / ReadableVector.Utils.norm(wrappedVector), wrappedVector)), new ReadableVector.Scale(-(d = ReadableVector.Utils.innerProduct(scale, (ReadableVector)wrappedVector)), scale))) < this.err); ++i) {
            }
            return d;
        }

        private static WrappedVector getInitialGuess(int n) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = MathUtils.nextDouble();
            }
            return new WrappedVector.Raw(dArray);
        }
    }
}

