/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.LinkageConstraints;
import dr.evolution.MetagenomeData;
import dr.evolution.alignment.Alignment;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxa;
import dr.evolution.util.TaxonList;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class MetagenomeDataParser
extends AbstractXMLObjectParser {
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new ElementRule(Taxa.class), new ElementRule(Tree.class)), new ElementRule(Alignment.class), new ElementRule(LinkageConstraints.class, true), AttributeRule.newBooleanRule("fixedReferenceTree", true, "Whether the reference tree should be of fixed topology")};

    @Override
    public String getParserDescription() {
        return "Data representing metagenome reads aligned to reference sequences and a reference tree";
    }

    @Override
    public Class getReturnType() {
        return MetagenomeData.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        TaxonList taxonList = null;
        taxonList = (TaxonList)xMLObject.getChild(TaxonList.class);
        if (taxonList == null) {
            taxonList = (Tree)xMLObject.getChild(Tree.class);
        }
        Alignment alignment = (Alignment)xMLObject.getChild(Alignment.class);
        LinkageConstraints linkageConstraints = (LinkageConstraints)xMLObject.getChild(LinkageConstraints.class);
        boolean bl = false;
        if (xMLObject.hasAttribute("fixedReferenceTree")) {
            bl = xMLObject.getBooleanAttribute("fixedReferenceTree");
        }
        MetagenomeData metagenomeData = new MetagenomeData(taxonList, alignment, linkageConstraints, bl);
        return metagenomeData;
    }

    @Override
    public String getParserName() {
        return "MetagenomeData";
    }
}

