/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.Patterns;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ConstantPatternsParser
extends AbstractXMLObjectParser {
    public static final String CONSTANT_PATTERNS = "constantPatterns";
    private static final String COUNTS = "counts";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(PatternList.class), new ElementRule("counts", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

    @Override
    public String getParserName() {
        return CONSTANT_PATTERNS;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
        Parameter parameter = (Parameter)xMLObject.getElementFirstChild(COUNTS);
        Patterns patterns = new Patterns(patternList.getDataType(), patternList);
        for (int i = 0; i < patternList.getDataType().getStateCount(); ++i) {
            int[] nArray = new int[patterns.getPatternLength()];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = i;
            }
            patterns.addPattern(nArray, parameter.getParameterValue(i));
        }
        return patterns;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "Creates a set of patterns for constant sites with weights as provided.";
    }

    @Override
    public Class getReturnType() {
        return PatternList.class;
    }
}

