/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Collections;
import java.util.List;

public abstract class TreeTransform
extends AbstractModel
implements TreeTraitProvider,
Citable {
    public static final String TREE_TRANSFORM_PREFIX = "treeTransform";
    private final TreeTraitProvider.Helper treeTraits = new TreeTraitProvider.Helper();

    public TreeTransform(String string) {
        super(string);
        this.setupTraits();
    }

    private void setupTraits() {
        TreeTrait.D d = new TreeTrait.D(){

            @Override
            public String getTraitName() {
                return TreeTransform.TREE_TRANSFORM_PREFIX;
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Double getTrait(Tree tree, NodeRef nodeRef) {
                return TreeTransform.this.getScaleForNode(tree, nodeRef);
            }

            @Override
            public boolean getLoggable() {
                return true;
            }
        };
        this.treeTraits.addTrait(d);
    }

    public abstract double transform(Tree var1, NodeRef var2, double var3);

    protected abstract double getScaleForNode(Tree var1, NodeRef var2);

    public abstract String getInfo();

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.treeTraits.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.treeTraits.getTreeTrait(string);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Branch-specific phenotypic mixture model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.VRANCKEN_2015_SIMULTANEOUSLY);
    }
}

