/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.geo.math.SphericalPolarCoordinates;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class GreatCircleDiffusionModel
extends MultivariateDiffusionModel {
    public static final String DIFFUSION_PROCESS = "greatCircleDiffusionModel";
    public static final String DIFFUSION_CONSTANT = "precision";
    public static final String COEFFICIENT = "diffusionCoefficient";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class), new ElementRule("diffusionCoefficient", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, true)};

        @Override
        public String getParserName() {
            return GreatCircleDiffusionModel.DIFFUSION_PROCESS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            Parameter parameter2 = null;
            if (xMLObject.hasChildNamed(GreatCircleDiffusionModel.COEFFICIENT)) {
                parameter2 = (Parameter)xMLObject.getChild(GreatCircleDiffusionModel.COEFFICIENT).getChild(Parameter.class);
            }
            return new GreatCircleDiffusionModel(parameter, parameter2);
        }

        @Override
        public String getParserDescription() {
            return "Describes a bivariate diffusion process using great circle distances.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultivariateDiffusionModel.class;
        }
    };
    private Parameter precision;
    private Parameter coefficient;

    public GreatCircleDiffusionModel(Parameter parameter, Parameter parameter2) {
        this.precision = parameter;
        this.addVariable(parameter);
        this.coefficient = parameter2;
        if (parameter2 != null) {
            this.addVariable(parameter2);
        }
    }

    public GreatCircleDiffusionModel(Parameter parameter) {
        this(parameter, null);
    }

    @Override
    protected double calculateLogDensity(double[] dArray, double[] dArray2, double d) {
        SphericalPolarCoordinates sphericalPolarCoordinates = new SphericalPolarCoordinates(dArray[0], dArray[1]);
        SphericalPolarCoordinates sphericalPolarCoordinates2 = new SphericalPolarCoordinates(dArray2[0], dArray2[1]);
        double d2 = sphericalPolarCoordinates.distance(sphericalPolarCoordinates2);
        double d3 = this.precision.getParameterValue(0) / d;
        if (this.coefficient == null) {
            return -LOG2PI + Math.log(d3) - 0.5 * (d2 * d2 * d3);
        }
        double d4 = -this.coefficient.getParameterValue(0);
        return -LOG2PI + d4 * Math.log(d3) - 0.5 * (d2 * d2 * Math.pow(d3, d4));
    }

    @Override
    protected void calculatePrecisionInfo() {
    }
}

