/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;

public abstract class BivariateTraitBranchAttributeProvider
extends TreeTrait.DefaultBehavior
implements TreeTrait<Double> {
    public static final String FORMAT = "%5.4f";
    protected AbstractMultivariateTraitLikelihood traitLikelihood;
    protected String traitName;
    protected String label;

    public BivariateTraitBranchAttributeProvider(AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood) {
        this.traitName = abstractMultivariateTraitLikelihood.getTraitParameter().getId();
        this.label = this.traitName + this.extensionName();
        double[] dArray = abstractMultivariateTraitLikelihood.getRootNodeTrait();
        if (dArray.length != 2) {
            throw new RuntimeException("BivariateTraitBranchAttributeProvider only works for 2D traits");
        }
    }

    protected abstract String extensionName();

    protected double branchFunction(double[] dArray, double[] dArray2, double d, double d2) {
        return this.convert(dArray2[0] - dArray[0], dArray2[1] - dArray[1], d - d2);
    }

    protected abstract double convert(double var1, double var3, double var5);

    @Override
    public String getTraitName() {
        return this.label;
    }

    @Override
    public TreeTrait.Intent getIntent() {
        return TreeTrait.Intent.BRANCH;
    }

    @Override
    public Class getTraitClass() {
        return Double.class;
    }

    public int getDimension() {
        return 1;
    }

    @Override
    public Double getTrait(Tree tree, NodeRef nodeRef) {
        if (tree != this.traitLikelihood.getTreeModel()) {
            throw new RuntimeException("Bad bug.");
        }
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        double[] dArray = this.traitLikelihood.getTraitForNode(tree, nodeRef2, this.traitName);
        double[] dArray2 = this.traitLikelihood.getTraitForNode(tree, nodeRef, this.traitName);
        double d = tree.getNodeHeight(nodeRef2);
        double d2 = tree.getNodeHeight(nodeRef);
        return this.branchFunction(dArray, dArray2, d, d2);
    }

    @Override
    public String getTraitString(Tree tree, NodeRef nodeRef) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        double[] dArray = this.traitLikelihood.getTraitForNode(tree, nodeRef2, this.traitName);
        double[] dArray2 = this.traitLikelihood.getTraitForNode(tree, nodeRef, this.traitName);
        double d = tree.getNodeHeight(nodeRef2);
        double d2 = tree.getNodeHeight(nodeRef);
        return String.format(FORMAT, this.branchFunction(dArray, dArray2, d, d2));
    }
}

