/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public interface ContinuousBranchValueProvider {
    public double getBranchValue(Tree var1, NodeRef var2);

    public static class ConstrainedMidPoint
    extends AbstractModel
    implements ContinuousBranchValueProvider {
        static final String NAME = "constrainedMidPoint";
        private final Parameter heightLowerBound;

        public ConstrainedMidPoint(Parameter parameter) {
            super(NAME);
            this.heightLowerBound = parameter;
            this.addVariable(parameter);
        }

        @Override
        public double getBranchValue(Tree tree, NodeRef nodeRef) {
            assert (tree.getRoot() != nodeRef);
            double d = tree.getNodeHeight(tree.getParent(nodeRef));
            double d2 = tree.getNodeHeight(nodeRef);
            double d3 = d < this.heightLowerBound.getParameterValue(0) ? this.heightLowerBound.getParameterValue(0) : (d2 < this.heightLowerBound.getParameterValue(0) ? (0.5 * d * d + 0.5 * this.heightLowerBound.getParameterValue(0) * this.heightLowerBound.getParameterValue(0) - this.heightLowerBound.getParameterValue(0) * d2) / (d - d2) : 0.5 * (d2 + d));
            return this.transform(d3);
        }

        double transform(double d) {
            return Math.log(d);
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
        }

        @Override
        protected void storeState() {
        }

        @Override
        protected void restoreState() {
        }

        @Override
        protected void acceptState() {
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        }
    }

    public static class MidPoint
    implements ContinuousBranchValueProvider {
        @Override
        public double getBranchValue(Tree tree, NodeRef nodeRef) {
            assert (tree.getRoot() != nodeRef);
            double d = (tree.getNodeHeight(tree.getParent(nodeRef)) + tree.getNodeHeight(nodeRef)) * 0.5;
            return this.transform(d);
        }

        double transform(double d) {
            return Math.log(d);
        }
    }
}

