/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.ARGPartitionLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class UniformPartitionLikelihood
extends ARGPartitionLikelihood
implements Likelihood {
    public static final String UNIFORM_PARTITION_LIKELIHOOD = "uniformPartitionLikelihood";
    private double logStateCount;
    private boolean isRecombination;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return UniformPartitionLikelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(ARGModel.class, false)};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            String string = "";
            if (xMLObject.hasId()) {
                string = xMLObject.getId();
            }
            return new UniformPartitionLikelihood(string, aRGModel);
        }

        @Override
        public String getParserName() {
            return UniformPartitionLikelihood.UNIFORM_PARTITION_LIKELIHOOD;
        }
    };

    public UniformPartitionLikelihood(String string, ARGModel aRGModel) {
        super(string, aRGModel);
        this.isRecombination = aRGModel.isRecombinationPartitionType();
        int n = this.getNumberOfPartitionsMinusOne();
        if (aRGModel.isRecombinationPartitionType()) {
            this.logStateCount = Math.log(n);
        } else {
            double d = Math.pow(2.0, n) - 1.0;
            this.logStateCount = Math.log(d);
        }
    }

    @Override
    public double[] generatePartition() {
        if (this.isRecombination) {
            return this.generateRecombinationPartition();
        }
        return this.generateReassortmentPartition();
    }

    private double[] generateRecombinationPartition() {
        int n;
        int n2 = this.getNumberOfPartitionsMinusOne();
        int n3 = MathUtils.nextInt(n2);
        boolean bl = false;
        boolean bl2 = true;
        double[] dArray = new double[n2 + 1];
        for (n = 0; n < n3 + 1; ++n) {
            dArray[n] = (double)bl;
        }
        for (n = n3 + 1; n < dArray.length; ++n) {
            dArray[n] = (double)bl2;
        }
        return dArray;
    }

    public static double arraySum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    private double[] generateReassortmentPartition() {
        int n = this.getNumberOfPartitionsMinusOne() + 1;
        double[] dArray = new double[n];
        while (UniformPartitionLikelihood.arraySum(dArray) == 0.0) {
            for (int i = 1; i < dArray.length; ++i) {
                dArray[i] = MathUtils.nextBoolean() ? 1.0 : 0.0;
            }
        }
        dArray[0] = 0.0;
        return dArray;
    }

    @Override
    public double getLogLikelihood(double[] dArray) {
        return -this.logStateCount;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void storeState() {
    }
}

