/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.multidimensionalscaling;

import dr.evomodel.antigenic.MultidimensionalScalingLikelihood;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.multidimensionalscaling.MassivelyParallelMDSImpl;
import dr.inference.multidimensionalscaling.MultiDimensionalScalingCore;
import dr.inference.multidimensionalscaling.MultiDimensionalScalingCoreImpl;
import dr.util.DataTable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;

public class MultiDimensionalScalingLikelihood
extends AbstractModelLikelihood
implements Reportable,
GradientWrtParameterProvider {
    private static final String REQUIRED_FLAGS_PROPERTY = "mds.required.flags";
    private static final String MULTIDIMENSIONAL_SCALING_LIKELIHOOD = "multiDimensionalScalingLikelihood";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        static final String FILE_NAME = "fileName";
        static final String LOCATIONS = "locations";
        static final String MDS_DIMENSION = "mdsDimension";
        static final String MDS_PRECISION = "mdsPrecision";
        static final String INCLUDE_TRUNCATION = "includeTruncation";
        static final String USE_OLD = "useOld";
        static final String FORCE_REORDER = "forceReorder";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("fileName", false, "The name of the file containing the assay table"), AttributeRule.newIntegerRule("mdsDimension", false, "The dimension of the space for MDS"), new ElementRule("locations", MatrixParameterInterface.class), AttributeRule.newBooleanRule("useOld", true), AttributeRule.newBooleanRule("includeTruncation", true), AttributeRule.newBooleanRule("forceReorder", true), new ElementRule("mdsPrecision", Parameter.class)};

        @Override
        public String getParserName() {
            return MultiDimensionalScalingLikelihood.MULTIDIMENSIONAL_SCALING_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DataTable<double[]> dataTable;
            String string = xMLObject.getStringAttribute(FILE_NAME);
            try {
                dataTable = DataTable.Double.parse(new FileReader(string));
            }
            catch (IOException iOException) {
                throw new XMLParseException("Unable to read assay data from file: " + iOException.getMessage());
            }
            if (dataTable.getRowCount() != dataTable.getColumnCount()) {
                throw new XMLParseException("Data table is not symmetrical.");
            }
            int n = xMLObject.getIntegerAttribute(MDS_DIMENSION);
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getElementFirstChild(LOCATIONS);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(MDS_PRECISION);
            boolean bl = xMLObject.getAttribute(USE_OLD, false);
            boolean bl2 = xMLObject.getAttribute(INCLUDE_TRUNCATION, false);
            boolean bl3 = xMLObject.getAttribute(FORCE_REORDER, false);
            if (bl) {
                System.err.println("USE OLD");
                return new MultidimensionalScalingLikelihood(n, bl2, parameter, (MatrixParameter)matrixParameterInterface, dataTable);
            }
            return new MultiDimensionalScalingLikelihood(n, parameter, matrixParameterInterface, dataTable, bl2, bl3);
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of pairwise distance given vectors of coordinatesfor points according to the multidimensional scaling scheme of XXX & Rafferty (to fill in).";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultiDimensionalScalingLikelihood.class;
        }
    };
    private final int mdsDimension;
    private final int vectorDimension;
    private final int locationCount;
    private MultiDimensionalScalingCore mdsCore;
    private String[] locationLabels;
    private Parameter mdsPrecisionParameter;
    private MatrixParameterInterface locationsParameter;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private double storedLogLikelihood;
    private long flags = 0L;
    private double[] observations;
    private double[] gradient;

    @Override
    public String getReport() {
        return this.getId() + ": " + this.getLogLikelihood();
    }

    @Override
    public Likelihood getLikelihood() {
        return this;
    }

    @Override
    public Parameter getParameter() {
        return this.locationsParameter;
    }

    @Override
    public int getDimension() {
        return this.locationsParameter.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        if (this.gradient == null) {
            this.gradient = new double[this.locationsParameter.getDimension()];
        }
        this.mdsCore.getGradient(this.gradient);
        return this.gradient;
    }

    public MultiDimensionalScalingLikelihood(int n, Parameter parameter, MatrixParameterInterface matrixParameterInterface, DataTable<double[]> dataTable, boolean bl, boolean bl2) {
        super(MULTIDIMENSIONAL_SCALING_LIKELIHOOD);
        int n2;
        int n3;
        int[] nArray;
        int n4;
        this.mdsDimension = n;
        String[] stringArray = dataTable.getRowLabels();
        this.locationCount = n4 = dataTable.getRowCount();
        if (bl2) {
            nArray = this.getPermutation(stringArray, matrixParameterInterface);
        } else {
            nArray = new int[this.locationCount];
            for (int i = 0; i < this.locationCount; ++i) {
                nArray[i] = i;
            }
        }
        String[] stringArray2 = new String[this.locationCount];
        int n5 = n4 * n4;
        this.observations = new double[n5];
        ObservationType[] observationTypeArray = new ObservationType[n5];
        double[][] dArray = new double[n4][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            stringArray2[n3] = stringArray[nArray[n3]];
            double[] dArray2 = dataTable.getRow(nArray[n3]);
            for (n2 = n3 + 1; n2 < n4; ++n2) {
                double d = dArray2[nArray[n2]];
                dArray[n2][n3] = d;
                dArray[n3][n2] = d;
            }
        }
        n3 = 0;
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (i == n2) {
                    this.observations[n3] = 0.0;
                    observationTypeArray[n3] = ObservationType.POINT;
                } else {
                    this.observations[n3] = dArray[i][n2];
                    observationTypeArray[n3] = Double.isNaN(this.observations[n3]) ? ObservationType.MISSING : ObservationType.POINT;
                }
                ++n3;
            }
        }
        this.vectorDimension = this.initialize(n, parameter, bl, matrixParameterInterface, stringArray2, this.observations, observationTypeArray);
    }

    public double[] getObservations() {
        return this.observations;
    }

    public MatrixParameterInterface getMatrixParameter() {
        return this.locationsParameter;
    }

    private int[] getPermutation(String[] stringArray, MatrixParameterInterface matrixParameterInterface) {
        if (stringArray.length != matrixParameterInterface.getColumnDimension()) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        int n = stringArray.length;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(matrixParameterInterface.getColumnDimension());
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], i);
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)hashMap.get(matrixParameterInterface.getParameter(i).getParameterName());
            if (n2 == null) {
                Logger.getLogger("dr.app.beagle").info("Missing label!!!");
                continue;
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    private MultiDimensionalScalingCore getCore() {
        MultiDimensionalScalingCore multiDimensionalScalingCore;
        long l = 0L;
        String string = System.getProperty(REQUIRED_FLAGS_PROPERTY);
        if (string != null) {
            l = Long.parseLong(string.trim());
        }
        if (l >= 1L) {
            System.err.println("Attempting to use a native MDS core with flag: " + l + "; may the force be with you ....");
            multiDimensionalScalingCore = new MassivelyParallelMDSImpl();
            this.flags = l;
        } else {
            System.err.println("Computer mode found: " + l + " vs. " + string);
            multiDimensionalScalingCore = new MultiDimensionalScalingCoreImpl();
        }
        return multiDimensionalScalingCore;
    }

    public int getMdsDimension() {
        return this.mdsDimension;
    }

    public int getLocationCount() {
        return this.locationCount;
    }

    protected int initialize(int n, Parameter parameter, boolean bl, MatrixParameterInterface matrixParameterInterface, String[] stringArray, double[] dArray, ObservationType[] observationTypeArray) {
        this.mdsCore = this.getCore();
        if (bl) {
            this.flags |= 0x20L;
        }
        System.err.println("Initializing with flags: " + this.flags);
        this.mdsCore.initialize(n, this.locationCount, this.flags);
        this.locationLabels = stringArray;
        this.locationsParameter = matrixParameterInterface;
        int n2 = this.mdsCore.getInternalDimension();
        this.setupLocationsParameter(this.locationsParameter);
        this.addVariable(matrixParameterInterface);
        this.mdsPrecisionParameter = parameter;
        this.addVariable(parameter);
        this.mdsCore.setParameters(this.mdsPrecisionParameter.getParameterValues());
        this.mdsCore.setPairwiseData(dArray);
        this.updateAllLocations(matrixParameterInterface);
        this.makeDirty();
        return n2;
    }

    private void updateAllLocations(MatrixParameterInterface matrixParameterInterface) {
        this.mdsCore.updateLocation(-1, matrixParameterInterface.getParameterValues());
    }

    private void setupLocationsParameter(MatrixParameterInterface matrixParameterInterface) {
        int n;
        boolean bl;
        boolean bl2 = bl = matrixParameterInterface.getColumnDimension() > 0;
        if (bl) {
            if (matrixParameterInterface.getColumnDimension() != this.locationCount) {
                throw new RuntimeException("locationsParameter column dimension (" + matrixParameterInterface.getColumnDimension() + ") is not equal to the locationCount (" + this.locationCount + ")");
            }
            if (matrixParameterInterface.getRowDimension() != this.mdsDimension) {
                throw new RuntimeException("locationsParameter row dimension (" + matrixParameterInterface.getRowDimension() + ") is not equal to the mdsDimension (" + this.mdsDimension + ")");
            }
        } else {
            throw new IllegalArgumentException("Dimensions on matrix must be set");
        }
        for (n = 0; n < this.locationLabels.length; ++n) {
            if (matrixParameterInterface.getParameter(n).getParameterName().compareTo(this.locationLabels[n]) == 0) continue;
            throw new RuntimeException("Mismatched trait parameter name (" + matrixParameterInterface.getParameter(n).getParameterName() + ") and data dimension name (" + this.locationLabels[n] + ")");
        }
        for (n = 0; n < matrixParameterInterface.getColumnDimension(); ++n) {
            Parameter parameter = matrixParameterInterface.getParameter(n);
            try {
                parameter.getBounds();
                continue;
            }
            catch (NullPointerException nullPointerException) {
                parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, parameter.getDimension()));
            }
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.locationsParameter) {
            if (n == -1) {
                this.updateAllLocations(this.locationsParameter);
            } else {
                int n2 = n / this.mdsDimension;
                this.mdsCore.updateLocation(n2, this.locationsParameter.getColumnValues(n2));
            }
        } else if (variable == this.mdsPrecisionParameter) {
            this.mdsCore.setParameters(this.mdsPrecisionParameter.getParameterValues());
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
        this.mdsCore.storeState();
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
        this.mdsCore.restoreState();
    }

    @Override
    protected void acceptState() {
        this.mdsCore.acceptState();
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.mdsCore.makeDirty();
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.mdsCore.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public double getMDSPrecision() {
        return this.mdsPrecisionParameter.getParameterValue(0);
    }

    public static enum ObservationType {
        POINT,
        UPPER_BOUND,
        LOWER_BOUND,
        MISSING;

    }
}

