/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.PowerLawGrowth;
import dr.evolution.util.Units;

public class FlexibleGrowth
extends PowerLawGrowth {
    private double K;

    public FlexibleGrowth(Units.Type type) {
        super(type);
    }

    public double getK() {
        return this.K;
    }

    public void setK(double d) {
        this.K = d;
    }

    @Override
    public double getDemographic(double d) {
        if (d > 0.0) {
            throw new RuntimeException("Negative times only! t=" + d);
        }
        return this.getN0() * this.K * Math.pow(-d, this.getR()) / (1.0 + this.K * Math.pow(-d, this.getR() - 1.0));
    }

    @Override
    public double getIntensity(double d) {
        throw new RuntimeException("getIntensity is not implemented (and not finite); use getIntegral instead");
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getInverseIntegral(double d, double d2) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getIntegral(double d, double d2) {
        return 1.0 / this.getN0() * (1.0 / ((this.getR() - 1.0) * this.K) * (Math.pow(-d2, -this.getR() + 1.0) - Math.pow(-d, -this.getR() + 1.0)) + Math.log(-d / -d2));
    }

    @Override
    public int getNumArguments() {
        return 3;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "K";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getR();
            }
            case 2: {
                return this.getK();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setR(d);
                break;
            }
            case 2: {
                this.setK(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Double.NEGATIVE_INFINITY;
            }
            case 2: {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public DemographicFunction getCopy() {
        FlexibleGrowth flexibleGrowth = new FlexibleGrowth(this.getUnits());
        flexibleGrowth.setN0(this.getN0());
        flexibleGrowth.setR(this.getR());
        flexibleGrowth.K = this.K;
        return flexibleGrowth;
    }
}

