/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.distance.DistanceMatrix;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.UPGMATree;
import dr.evolution.util.Date;
import dr.evolution.util.TimeScale;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.Serializable;
import java.util.logging.Logger;

public class UPGMATreeParser
extends AbstractXMLObjectParser {
    public static final String UPGMA_TREE = "upgmaTree";
    public static final String ROOT_HEIGHT = "rootHeight";
    public static final String RANDOMIZE = "nonzeroBranchLengths";
    private static double tolerance = 0.0;
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("usingDates", true), AttributeRule.newDoubleRule("rootHeight", true), AttributeRule.newBooleanRule("nonzeroBranchLengths", true), new ElementRule(DistanceMatrix.class)};

    @Override
    public String getParserName() {
        return UPGMA_TREE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        double d;
        Serializable serializable;
        int n;
        double d2;
        boolean bl = false;
        boolean bl2 = true;
        double d3 = xMLObject.getAttribute(ROOT_HEIGHT, -1.0);
        if (xMLObject.hasAttribute("usingDates")) {
            bl = true;
            bl2 = xMLObject.getBooleanAttribute("usingDates");
        }
        DistanceMatrix distanceMatrix = (DistanceMatrix)xMLObject.getChild(DistanceMatrix.class);
        UPGMATree uPGMATree = new UPGMATree(distanceMatrix);
        if (d3 > 0.0) {
            d2 = d3 / uPGMATree.getNodeHeight(uPGMATree.getRoot());
            for (n = 0; n < uPGMATree.getInternalNodeCount(); ++n) {
                serializable = uPGMATree.getInternalNode(n);
                d = uPGMATree.getNodeHeight((NodeRef)serializable);
                uPGMATree.setNodeHeight((NodeRef)serializable, d * d2);
            }
        }
        if (bl2) {
            int n2;
            TimeScale timeScale = null;
            for (n2 = 0; n2 < uPGMATree.getTaxonCount(); ++n2) {
                Date date = (Date)uPGMATree.getTaxonAttribute(n2, "date");
                if (date == null) {
                    date = (Date)uPGMATree.getNodeAttribute(uPGMATree.getExternalNode(n2), "date");
                }
                if (date == null || timeScale != null && !date.after((Date)timeScale)) continue;
                timeScale = date;
            }
            for (n2 = 0; n2 < uPGMATree.getInternalNodeCount(); ++n2) {
                Date date = (Date)uPGMATree.getNodeAttribute(uPGMATree.getInternalNode(n2), "date");
                if (date == null || timeScale != null && !date.after((Date)timeScale)) continue;
                timeScale = date;
            }
            if (timeScale == null) {
                if (bl) {
                    throw new XMLParseException("no date elements in tree (and usingDates attribute set)");
                }
            } else {
                TimeScale timeScale2 = new TimeScale(timeScale.getUnits(), true, ((Date)timeScale).getAbsoluteTimeValue());
                for (n = 0; n < uPGMATree.getTaxonCount(); ++n) {
                    serializable = (Date)uPGMATree.getTaxonAttribute(n, "date");
                    if (serializable == null) {
                        serializable = (Date)uPGMATree.getNodeAttribute(uPGMATree.getExternalNode(n), "date");
                    }
                    if (serializable == null) continue;
                    d = timeScale2.convertTime(((Date)serializable).getTimeValue(), (TimeScale)serializable);
                    uPGMATree.setNodeHeight(uPGMATree.getExternalNode(n), d);
                }
                for (n = 0; n < uPGMATree.getInternalNodeCount(); ++n) {
                    serializable = (Date)uPGMATree.getNodeAttribute(uPGMATree.getInternalNode(n), "date");
                    if (serializable == null) continue;
                    d = timeScale2.convertTime(((Date)serializable).getTimeValue(), (TimeScale)serializable);
                    uPGMATree.setNodeHeight(uPGMATree.getInternalNode(n), d);
                }
                MutableTree.Utils.correctHeightsForTips(uPGMATree);
            }
        }
        if (d3 > 0.0) {
            d2 = d3 / uPGMATree.getNodeHeight(uPGMATree.getRoot());
            for (n = 0; n < uPGMATree.getInternalNodeCount(); ++n) {
                serializable = uPGMATree.getInternalNode(n);
                d = uPGMATree.getNodeHeight((NodeRef)serializable);
                uPGMATree.setNodeHeight((NodeRef)serializable, d * d2);
            }
        }
        if (xMLObject.getAttribute(RANDOMIZE, false).booleanValue()) {
            this.shakeTree(uPGMATree);
        }
        return uPGMATree;
    }

    private boolean shakeNode(UPGMATree uPGMATree, NodeRef nodeRef) {
        if (uPGMATree.isRoot(nodeRef) || uPGMATree.isExternal(nodeRef)) {
            return false;
        }
        boolean bl = false;
        if (uPGMATree.getBranchLength(nodeRef) <= tolerance) {
            bl = true;
        }
        double d = uPGMATree.getNodeHeight(uPGMATree.getParent(nodeRef));
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < uPGMATree.getChildCount(nodeRef); ++i) {
            double d3;
            NodeRef nodeRef2 = uPGMATree.getChild(nodeRef, i);
            if (uPGMATree.getBranchLength(nodeRef2) <= tolerance) {
                bl = true;
            }
            if (!((d3 = uPGMATree.getNodeHeight(nodeRef2)) > d2)) continue;
            d2 = d3;
        }
        if (bl) {
            double d4 = d2 + (d - d2) * MathUtils.nextDouble();
            uPGMATree.setNodeHeight(nodeRef, d4);
        }
        return bl;
    }

    private void shakeTree(UPGMATree uPGMATree) {
        int n;
        boolean bl = true;
        int[] nArray = new int[uPGMATree.getNodeCount()];
        for (n = 0; n < uPGMATree.getNodeCount(); ++n) {
            nArray[n] = n;
        }
        while (bl) {
            Logger.getLogger("dr.evomodelxml").info("Adjusting heights in UPGMA tree");
            MathUtils.permute(nArray);
            bl = false;
            for (n = 0; n < uPGMATree.getNodeCount(); ++n) {
                NodeRef nodeRef = uPGMATree.getNode(nArray[n]);
                if (!this.shakeNode(uPGMATree, nodeRef)) continue;
                bl = true;
            }
        }
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "This element returns a UPGMA tree generated from the given distances.";
    }

    @Override
    public Class getReturnType() {
        return UPGMATree.class;
    }
}

