/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import beagle.Beagle;
import beagle.BeagleFactory;
import beagle.BeagleFlag;
import beagle.InstanceDetails;
import beagle.ResourceDetails;
import dr.evolution.datatype.DataType;
import dr.evomodel.branchmodel.HomogeneousBranchModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.treedatalikelihood.BeagleFunctionality;
import dr.evomodel.treedatalikelihood.EvolutionaryProcessDelegate;
import dr.evomodel.treedatalikelihood.HomogenousSubstitutionModelDelegate;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

@Deprecated
public class BeagleMatrixExponentiationDelegate
extends AbstractModel
implements Citable {
    private static final String RESOURCE_AUTO_PROPERTY = "beagle.resource.auto";
    private static final String RESOURCE_ORDER_PROPERTY = "beagle.resource.order";
    private static final String PREFERRED_FLAGS_PROPERTY = "beagle.preferred.flags";
    private static final String REQUIRED_FLAGS_PROPERTY = "beagle.required.flags";
    private static final String SCALING_PROPERTY = "beagle.scaling";
    private static final String RESCALE_FREQUENCY_PROPERTY = "beagle.rescale";
    private static final String DELAY_SCALING_PROPERTY = "beagle.delay.scaling";
    private static final String EXTRA_BUFFER_COUNT_PROPERTY = "beagle.extra.buffer.count";
    private static final String FORCE_VECTORIZATION = "beagle.force.vectorization";
    private static final String THREAD_COUNT = "beagle.thread.count";
    private static int instanceCount = 0;
    private static List<Integer> resourceOrder = null;
    private static List<Integer> preferredOrder = null;
    private static List<Integer> requiredOrder = null;
    private static List<String> scalingOrder = null;
    private static List<Integer> extraBufferOrder = null;
    private static final boolean DEBUG = false;
    private final int branchCount;
    private boolean[] branchUpdates;
    private double[] branchLengths;
    private boolean[] storedBranchUpdates;
    private double[] storedBranchLengths;
    private final DataType dataType;
    private final int stateCount;
    private final SubstitutionModel substitutionModel;
    private final EvolutionaryProcessDelegate evolutionaryProcessDelegate;
    private final Beagle beagle;
    private boolean updateSubstitutionModel;

    public BeagleMatrixExponentiationDelegate(SubstitutionModel substitutionModel, int n) {
        super("BeagleMatrixExponentiationDelegate");
        Logger logger = Logger.getLogger("dr.evomodel");
        logger.info("\nUsing BEAGLE Matrix Exponentiation Delegate");
        this.substitutionModel = substitutionModel;
        this.dataType = this.substitutionModel.getDataType();
        this.stateCount = this.dataType.getStateCount();
        this.addModel(this.substitutionModel);
        this.branchCount = n;
        this.branchUpdates = new boolean[this.branchCount];
        this.storedBranchUpdates = new boolean[this.branchCount];
        this.branchLengths = new double[this.branchCount];
        this.storedBranchLengths = new double[this.branchCount];
        this.evolutionaryProcessDelegate = new HomogenousSubstitutionModelDelegate(null, new HomogeneousBranchModel(substitutionModel));
        if (resourceOrder == null) {
            resourceOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(RESOURCE_ORDER_PROPERTY);
        }
        if (preferredOrder == null) {
            preferredOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(PREFERRED_FLAGS_PROPERTY);
        }
        if (requiredOrder == null) {
            requiredOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(REQUIRED_FLAGS_PROPERTY);
        }
        if (extraBufferOrder == null) {
            extraBufferOrder = BeagleFunctionality.parseSystemPropertyIntegerArray(EXTRA_BUFFER_COUNT_PROPERTY);
        }
        int[] nArray = null;
        long l = 0L;
        long l2 = 0L;
        if (resourceOrder.size() > 0 && (nArray = new int[]{resourceOrder.get(instanceCount % resourceOrder.size()), 0})[0] > 0) {
            l |= BeagleFlag.PROCESSOR_GPU.getMask();
        }
        if (preferredOrder.size() > 0) {
            l = preferredOrder.get(instanceCount % preferredOrder.size()).intValue();
        }
        if (requiredOrder.size() > 0) {
            l2 = requiredOrder.get(instanceCount % requiredOrder.size()).intValue();
        }
        boolean bl = false;
        String string = System.getProperty(FORCE_VECTORIZATION);
        if (string != null) {
            bl = true;
        }
        int n2 = -1;
        String string2 = System.getProperty(THREAD_COUNT);
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
        }
        if (n2 == 0 || n2 == 1) {
            l &= BeagleFlag.THREADING_CPP.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            l |= BeagleFlag.THREADING_NONE.getMask();
        } else {
            l &= BeagleFlag.THREADING_NONE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            l |= BeagleFlag.THREADING_CPP.getMask();
        }
        if (BeagleFlag.VECTOR_SSE.isSet(l) && this.stateCount != 4 && !bl && !BeagleFunctionality.IS_ODD_STATE_SSE_FIXED()) {
            l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            l |= BeagleFlag.VECTOR_NONE.getMask();
        }
        if (!BeagleFlag.PRECISION_SINGLE.isSet(l)) {
            l |= BeagleFlag.PRECISION_DOUBLE.getMask();
        }
        if (this.evolutionaryProcessDelegate.canReturnComplexDiagonalization()) {
            l2 |= BeagleFlag.EIGEN_COMPLEX.getMask();
        }
        if (nArray == null && (BeagleFlag.PROCESSOR_GPU.isSet(l) || BeagleFlag.FRAMEWORK_CUDA.isSet(l) || BeagleFlag.FRAMEWORK_OPENCL.isSet(l)) || nArray != null && nArray[0] > 0) {
            l &= BeagleFlag.VECTOR_SSE.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
            l &= BeagleFlag.THREADING_CPP.getMask() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.beagle = BeagleFactory.loadBeagleInstance(0, 0, 0, this.stateCount, 0, this.evolutionaryProcessDelegate.getEigenBufferCount(), this.evolutionaryProcessDelegate.getMatrixBufferCount(), 0, 0, nArray, l, l2);
        InstanceDetails instanceDetails = this.beagle.getDetails();
        ResourceDetails resourceDetails = null;
        if (instanceDetails != null) {
            resourceDetails = BeagleFactory.getResourceDetails(instanceDetails.getResourceNumber());
            if (resourceDetails != null) {
                StringBuilder stringBuilder = new StringBuilder("  Using BEAGLE resource ");
                stringBuilder.append(resourceDetails.getNumber()).append(": ");
                stringBuilder.append(resourceDetails.getName()).append("\n");
                if (resourceDetails.getDescription() != null) {
                    String[] stringArray;
                    for (String string3 : stringArray = resourceDetails.getDescription().split("\\|")) {
                        if (string3.trim().length() <= 0) continue;
                        stringBuilder.append("    ").append(string3.trim()).append("\n");
                    }
                }
                stringBuilder.append("    with instance flags: ").append(instanceDetails.toString());
                logger.info(stringBuilder.toString());
            } else {
                logger.info("  Error retrieving BEAGLE resource for instance: " + instanceDetails.toString());
            }
        } else {
            logger.info("  No external BEAGLE resources available, or resource list/requirements not met, using Java implementation");
        }
        if (BeagleFunctionality.IS_THREAD_COUNT_COMPATIBLE() && n2 > 1) {
            this.beagle.setCPUThreadCount(n2);
        }
        this.updateSubstitutionModel = true;
        ++instanceCount;
    }

    public void calculateTransitionProbabilityMatrices() {
        int n = 0;
        int[] nArray = new int[this.branchCount];
        double[] dArray = new double[this.branchCount];
        for (int i = 0; i < this.branchCount; ++i) {
            if (!this.branchUpdates[i]) continue;
            nArray[n] = i;
            dArray[n] = dArray[i];
            ++n;
        }
        if (this.updateSubstitutionModel) {
            this.evolutionaryProcessDelegate.updateSubstitutionModels(this.beagle, true);
        }
        if (n > 0) {
            this.evolutionaryProcessDelegate.updateTransitionMatrices(this.beagle, nArray, dArray, n, true);
        }
        this.updateSubstitutionModel = false;
    }

    public void makeDirty() {
        this.updateSubstitutionModel = true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.substitutionModel) {
            this.updateSubstitutionModel = true;
        }
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public void storeState() {
        this.evolutionaryProcessDelegate.storeState();
        System.arraycopy(this.branchUpdates, 0, this.storedBranchUpdates, 0, this.branchCount);
        System.arraycopy(this.branchLengths, 0, this.storedBranchLengths, 0, this.branchCount);
    }

    @Override
    public void restoreState() {
        this.evolutionaryProcessDelegate.restoreState();
        boolean[] blArray = this.branchUpdates;
        this.branchUpdates = this.storedBranchUpdates;
        this.storedBranchUpdates = blArray;
        double[] dArray = this.branchLengths;
        this.branchLengths = this.storedBranchLengths;
        this.storedBranchLengths = dArray;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.FRAMEWORK;
    }

    @Override
    public String getDescription() {
        return "Using BEAGLE likelihood calculation library";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.AYRES_2012_BEAGLE);
    }
}

