% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bess.R
\name{plot.bess}
\alias{plot.bess}
\title{Produces a coefficient profile plot of the coefficient or loss function
paths}
\usage{
\method{plot}{bess}(
  x,
  type = c("loss", "tune", "coefficients", "both"),
  breaks = TRUE,
  K = NULL,
  sign.lambda = 0,
  ...
)
}
\arguments{
\item{x}{A \code{"bess"} object.}

\item{type}{One of \code{"loss"}, \code{"tune"}, \code{"coefficients"}, \code{"both"}. This option is only valid for \code{"bess"} object obtained from \code{"bss"}.
If \code{type = "loss"} (\code{type = "tune"}), a path of loss function (corresponding information criterion or cross-validation loss) is provided.
If \code{type = "coefficients"}, it provides a coefficient profile plot of the coefficient.
If \code{type = "both"}, it combines the path of corresponding information criterion or cross-validation loss with the coefficient profile plot.}

\item{breaks}{If \code{TRUE}, a vertical line is drawn at a specified break point in
the coefficient paths.}

\item{K}{Which break point should the vertical line be drawn at. Default is the optimal model size.}

\item{sign.lambda}{A logical value indicating whether to show lambda on log scale. Default is 0. Valid for \code{"bess"} object obtained from \code{"bsrr"}.}

\item{\dots}{Other graphical parameters to plot}
}
\description{
Produces a coefficient profile plot of the coefficient or loss function
paths
}
\examples{

# Generate simulated data
n <- 200
p <- 20
k <- 5
rho <- 0.4
seed <- 10
Tbeta <- rep(0, p)
Tbeta[1:k*floor(p/k):floor(p/k)] <- rep(1, k)
Data <- gen.data(n, p, k, rho, family = "gaussian", beta = Tbeta, seed = seed)
lm.bss <- bess(Data$x, Data$y, method = "sequential")
lambda.list <- exp(seq(log(5), log(0.1), length.out = 10))
lm.bsrr <- bess(Data$x, Data$y, type = "bsrr", method = "pgsection")

# generate plots
plot(lm.bss, type = "both", breaks = TRUE)
plot(lm.bsrr)


}
\references{
Wen, C., Zhang, A., Quan, S. and Wang, X. (2020). BeSS: An R
Package for Best Subset Selection in Linear, Logistic and Cox Proportional
Hazards Models, \emph{Journal of Statistical Software}, Vol. 94(4).
doi:10.18637/jss.v094.i04.
}
\seealso{
\code{\link{bess}}.
}
\author{
Canhong Wen, Aijun Zhang, Shijie Quan, Liyuan Hu, Kangkang Jiang, Yanhang Zhang, Jin Zhu and Xueqin Wang.
}
