% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BchronCheck.R
\name{BchronCheck}
\alias{BchronCheck}
\title{Check data for input into BchronCalibrate or Bchronology}
\usage{
BchronCheck(
  ages,
  ageSds,
  positions = NULL,
  pathToCalCurves = NULL,
  calCurves = NULL,
  positionThicknesses = NULL,
  ids = NULL,
  outlierProbs = NULL,
  predictPositions = NULL,
  jitterPositions = NULL,
  allowOutside = NULL,
  iterations = NULL,
  thetaStart = NULL,
  burn = NULL,
  thin = NULL,
  extractDate = NULL,
  maxExtrap = NULL,
  thetaMhSd = NULL,
  muMhSd = NULL,
  psiMhSd = NULL,
  ageScaleVal = NULL,
  positionEps = NULL,
  positionNormalise = NULL,
  eps = NULL,
  dfs = NULL,
  type = c("BchronCalibrate", "Bchronology")
)
}
\arguments{
\item{ages}{A vector of ages provided in years before 1950.}

\item{ageSds}{A vector of 1-sigma values for the ages given above}

\item{positions}{Position values (e.g. depths) for each age}

\item{pathToCalCurves}{File path to where the calibration curves are located. Defaults to the system directory where the 3 standard calibration curves are stored.}

\item{calCurves}{A vector of values containing either \code{intcal20}, \code{shcal20}, \code{marine20}, or \code{normal} (older calibration curves are supposed such as intcal13). Should be the same length the number of ages supplied. Non-standard calibration curves can be used provided they are supplied in the same format as those previously mentioned and are placed in the same directory. Normal indicates a normally-distributed (non-14C) age.}

\item{positionThicknesses}{Thickness values for each of the positions. The thickness value should be the full thickness value of the slice. By default set to zero.}

\item{ids}{ID names for each age}

\item{outlierProbs}{A vector of prior outlier probabilities, one for each age. Defaults to 0.01}

\item{predictPositions}{A vector of positions (e.g. depths) at which predicted age values are required. Defaults to a sequence of length 100 from the top position to the bottom position}

\item{jitterPositions}{Whether to jigger the positions at startup or not. Default is FALSE but if there are lots of dates at similar depths this may resolve some initialisation problems}

\item{allowOutside}{Whether to allow calibrations to run outside the range of the calibration curve. By default this is turned off as calibrations outside of the range of the calibration curve can cause severe issues with probability ranges of calibrated dates}

\item{iterations}{The number of iterations to run the procedure for}

\item{thetaStart}{A set of starting values for the calendar ages estimated by Bchron. If NULL uses a function to estimate the ages. These should be in the same units as the posterior ages required. See example below for usage.}

\item{burn}{The number of starting iterations to discard}

\item{thin}{The step size for every iteration to keep beyond the burn-in}

\item{extractDate}{The top age of the core. Used for extrapolation purposes so that no extrapolated ages go beyond the top age of the core. Defaults to the current year}

\item{maxExtrap}{The maximum number of extrapolations to perform before giving up and setting the predicted ages to NA. Useful for when large amounts of extrapolation are required, i.e. some of the \code{predictPositions} are a long way from the dated positions}

\item{thetaMhSd}{The Metropolis-Hastings standard deviation for the age parameters}

\item{muMhSd}{The Metropolis-Hastings standard deviation for the Compound Poisson-Gamma mean}

\item{psiMhSd}{The Metropolis-Hastings standard deviation for the Compound Poisson-Gamma scale}

\item{ageScaleVal}{A scale value for the ages. \code{Bchronology} works best when the ages are scaled to be approximately between 0 and 100. The default value is thus 1000 for ages given in years.}

\item{positionEps}{A small value used to check whether simulated positions are far enough apart to avoid numerical underflow errors. If errors occur in model runs (e.g. \code{missing value where TRUE/FALSE needed} increase this value)}

\item{positionNormalise}{Whether to normalise the position values. \code{Bchronology} works best when the positions are normalise to be between 0 and 1 The default value is \code{TRUE}}

\item{eps}{Cut-off point for density calculation. A value of eps>0 removes ages from the output which have negligible probability density}

\item{dfs}{Degrees-of-freedom values for the t-distribution associated with the calibration calculation. A large value indicates Gaussian distributions assumed for the 14C ages}

\item{type}{Whether this function has been called to check parameters for calibration purposes (\code{BchronCalibrate}) or chronology purposes (\code{Bchronology})}
}
\value{
This function returns nothing other than a message.
}
\description{
Function to be used for checking the data formats in \code{\link{BchronCalibrate}} and \code{\link{Bchronology}}. Mostly to be used internally to avoid Bchron running into problems with bad data specifications, but might also be useful for
}
\examples{
data(Glendalough)

# Check the Glendalough data are in the right format
with(
  Glendalough,
  BchronCheck(ages,
    ageSds,
    position,
    pathToCalCurves = system.file("data", package = "Bchron"),
    calCurves,
    type = "BchronCalibrate"
  )
)
}
