% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VSEM.R
\name{VSEM}
\alias{VSEM}
\title{Very simple ecosystem model}
\usage{
VSEM(pars = c(KEXT = 0.5, LAR = 1.5, LUE = 0.002, GAMMA = 0.4, tauV = 1440,
  tauS = 27370, tauR = 1440, Av = 0.5, Cv = 3, Cs = 15, Cr = 3), PAR,
  C = TRUE)
}
\arguments{
\item{pars}{a parameter vector}

\item{PAR}{Photosynthetically active radiation (PAR) MJ /m2 /day}

\item{C}{switch to choose whether to use the C or R version of the model. C is much faster.}

\item{KEXT}{Light extinction coefficient m2 ground area / m2 leaf area}

\item{LAR}{Leaf area ratio m2 leaf area / kg aboveground vegetation}

\item{LUE}{Light-Use Efficiency (kg C MJ-1 PAR)}

\item{GAMMA}{Autotrophic respiration as a fraction of GPP}

\item{tauV}{Longevity of aboveground vegetation days}

\item{tauR}{Longevity of belowground vegetation days}

\item{tauS}{Residence time of soil organic matter d}
}
\value{
a matrix with colums NEE, CV, CR and CS units and explanations see details
}
\description{
A very simple ecosystem model, based on three carbon pools and a basic LUE model
}
\details{
This Very Simple Ecosystem Model (VSEM) is a 'toy' model designed to be very simple but yet bear some resemblance to deterministic processed based ecosystem models (PBMs) that are commonly used in forest modelling.

The model determines the accumulation of carbon in the plant and soil from the growth of the plant via photosynthesis and senescence to the soil which respires carbon back to the atmosphere.

The model calculates Gross Primary Productivity (GPP) using a very simple light-use efficiency (LUE) formulation multiplied by light interception. Light interception is calculated via Beer's law with a constant light extinction coefficient operating on Leaf Area Index (LAI).

A parameter (GAMMA) determines the fraction of GPP that is autotrophic respiration. The Net Primary Productivity (NPP) is then allocated to above and below-ground vegetation via a fixed allocation fraction. Carbon is lost from the plant pools to a single soil pool via fixed turnover rates. Heterotropic respiration in the soil is determined via a soil turnover rate.

The model equations are 

-- Photosynthesis

\deqn{LAI = LAR*Cv}
\deqn{GPP = PAR * LUE * (1 - \exp^{(-KEXT * LAI)})}
\deqn{NPP = (1-GAMMA) * GPP}

-- State equations
\deqn{dCv/dt  = Av * NPP - Cv/tauV}
\deqn{dCr/dt  = (1.0-Av) * NPP - Cr/tauR}
\deqn{dCs/dt  = Cr/tauR + Cv/tauV - Cs/tauS}

The model time-step is daily.

-- VSEM inputs:

PAR    Photosynthetically active radiation (PAR) MJ /m2 /day

-- VSEM parameters:

KEXT   Light extinction coefficient m2 ground area / m2 leaf area

LAR    Leaf area ratio m2 leaf area / kg aboveground vegetation

LUE    Light-Use Efficiency (kg C MJ-1 PAR)

GAMMA  Autotrophic respiration as a fraction of GPP

tauV   Longevity of aboveground vegetation days

tauR   Longevity of belowground vegetation days

tauS   Residence time of soil organic matter d

-- VSEM states:

Cv     Above-ground vegetation pool kg C / m2

Cr     Below-ground vegetation pool kg C / m2

Cs     Carbon in organic matter kg C / m2

-- VSEM fluxes:

G     Gross Primary Productivity kg C /m2 /day

NPP   Net Primary Productivity kg C /m2 /day

NEE   Net Ecosystem Exchange kg C /m2 /day
}
\seealso{
\code{\link{VSEMgetDefaults}}, \code{\link{VSEMcreatePAR}}, , \code{\link{VSEMcreateLikelihood}}
}
\author{
David Cameron, R and C implementation by Florian Hartig
}
