% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_sampsize.R
\name{bayes_sampsize}
\alias{bayes_sampsize}
\title{Determine the required sample size for a Bayesian hypothesis test}
\usage{
bayes_sampsize(h1, h2, m1, m2, type = 1, cutoff, bound1 = 1,
  bound2 = 1/bound1, datasets = 1000, nsamp = 1000, minss = 2,
  maxss = 1000, seed = 31)
}
\arguments{
\item{h1}{A constraint matrix defining H1.}

\item{h2}{A constraint matrix defining H2.}

\item{m1}{A vector of expected population means under H1 (standardized).}

\item{m2}{A vector of expected populations means under H2 (standardized).
\code{m2} must be of same length as \code{m1}}

\item{type}{A character. The type of error to be controlled
options are: \code{"1", "2", "de", "aoi", "med.1", "med.2"}}

\item{cutoff}{A number. The cutoff criterion for type.
If \code{type} is \code{"1", "2", "de", "aoi"}, \code{cutoff} must be between 0 and 1
If \code{type} is \code{"med.1" or "med.2"}, \code{cutoff} must be larger than 1}

\item{bound1}{A number. The boundary above which BF12 favors H1}

\item{bound2}{A number. The boundary below which BF12 favors H2}

\item{datasets}{A number. The number of datasets to compute the error probabilities}

\item{nsamp}{A number. The number of prior or posterior samples to determine the
fit and complexity}

\item{minss}{A number. The minimum sample size to consider}

\item{maxss}{A number. The maximum sample size to consider}

\item{seed}{A number. The random seed to be set}
}
\value{
The sample size for which the chosen type of error probability
is at the set cutoff, and the according error probabilities and median Bayes factors
}
\description{
Determine the required sample size for a Bayesian hypothesis test
}
\examples{
# Short computation example NOT SUFFICIENT SAMPLES
h1 <- matrix(c(1,-1), nrow= 1, byrow= TRUE)
h2 <- 'c'
m1 <- c(.4, 0)
m2 <- c(0, .1)
bayes_sampsize(h1, h2, m1, m2, "de", .125, nsamp = 50, datasets = 50,
minss = 40, maxss = 70)
\donttest{
# Example 1 Decision error and Hc
h1 <- matrix(c(1,-1,0,0,1,-1), nrow= 2, byrow= TRUE)
h2 <- 'c'
m1 <- c(.4,.2,0)
m2 <- c(.2,0,.1)
bayes_sampsize(h1, h2, m1, m2, "de", .125)

# Example 2 Indecision error and H2
h1 <- matrix(c(1,-1,0,0,0,1,-1,0,0,0,1,-1), nrow= 3, byrow= TRUE)
h2 <- matrix(c(0,-1,1,0,0,1,0,-1,-1,0,0,1), nrow = 3, byrow= TRUE)
m1 <- c(.7,.3,.1,0)
m2 <- c(0,.4,.5,.1)
bayes_sampsize(h1, h2, m1, m2, type = "aoi", cutoff = .2, minss = 2,
maxss = 500)
}
}
