% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFunction.R
\name{simulatetrial}
\alias{simulatetrial}
\title{simulatetrial}
\usage{
simulatetrial(
  ii,
  response.probs = c(0.4, 0.4),
  ns = c(30, 60, 90, 120, 150),
  test.type = "Twoside",
  max.ar = 0.75,
  rand.algo = "Urn",
  max.deviation = 3,
  model.inf = list(model = "tlr", ibb.inf = list(pi.star = 0.5, pess = 2,
    betabinomialmodel = ibetabinomial.post), tlr.inf = list(beta0_prior_mu = 0,
    beta1_prior_mu = 0, beta0_prior_sigma = 2.5, beta1_prior_sigma = 2.5, beta0_df = 7,
    beta1_df = 7, reg.inf = "main", variable.inf = "Fixeffect")),
  Stopbound.inf = Stopbound.inf,
  Random.inf = Random.inf,
  trend.inf = trend.inf
)
}
\arguments{
\item{ii}{Meaning less parameter but required for foreach function in doParallel package}

\item{response.probs}{A vector of true response probability for each arm. Default response.probs = c(0.4, 0.4).}

\item{ns}{A vector of accumulated number of patient at each stage. Default is ns = c(30, 60, 90, 120, 150).}

\item{test.type}{A indicator of whether to use one side test or two side test for each treatment-control comparison.}

\item{max.ar}{The upper boundary for randomisation ratio for each arm. Default is 0.75 for a two arm trial. The minimum value depends on K where 1 - max.ar <= 1/K}

\item{rand.algo}{The method of applying patient allocation with a given randomisation probability vector. Default is "Urn".}

\item{max.deviation}{The tuning parameter for Urn randomisation method. Default is 3.}

\item{model.inf}{The list of interim data analysis model information for more see \code{\link{modelinf.fun}}}

\item{Stopbound.inf}{The list of stop boundary information for more see \code{\link{Stopboundinf}}}

\item{Random.inf}{The list of Adaptive randomisation information for more see \code{\link{Randomisation.inf}}}

\item{trend.inf}{The list of time trend information}
}
\value{
A matrix including all evaluation metrics
}
\description{
This function simulates a MAMS trial applying adaptive methods where the time trend effect can be studied.
}
\examples{
set.seed(1)
simulatetrial(response.probs = c(0.4, 0.4),
               ns = c(30, 60, 90, 120, 150),
               max.ar = 0.75,
               test.type = "Twoside",
               rand.algo = "Urn",
               max.deviation = 3,
               model.inf = list(
               model = "tlr",
               ibb.inf = list(
               pi.star = 0.5,
               pess = 2,
               betabinomialmodel = ibetabinomial.post
               ),
               tlr.inf = list(
               beta0_prior_mu = 0,
               beta1_prior_mu = 0,
               beta0_prior_sigma = 2.5,
               beta1_prior_sigma = 2.5,
               beta0_df = 7,
               beta1_df = 7,
               reg.inf =  "main",
               variable.inf = "Fixeffect"
               )
               ),
               Stopbound.inf = Stopboundinf(
               Stop.type = "Early-Pocock",
               Boundary.type = "Symmetric",
               cutoff = c(0.99,0.01)
               ),
               Random.inf = list(
               Fixratio = FALSE,
               Fixratiocontrol = NA,
               BARmethod = "Thall",
               Thall.tuning.inf = list(tuningparameter = "Fixed",  fixvalue = 1),
               Trippa.tuning.inf = list(a = 10, b = 0.75)
               ),
               trend.inf = list(
               trend.type = "step",
               trend.effect = c(0, 0),
               trend_add_or_multip = "mult"
               ))
}
\author{
Ziyan Wang
}
