% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReshapeData.R
\name{ReshapeData}
\alias{ReshapeData}
\title{Reshape right censored data to be used with a piecewise exponential
prior.}
\usage{
ReshapeData(
  df,
  time = "time",
  event = "event",
  K = ceiling((dim(df)[1]/log(dim(df)[1]))^(1/2)),
  time.max = max(df[[time]])
)
}
\arguments{
\item{df}{A dataframe, containing at minimum a column with follow-up times
and a column with a status indicator (event observed or censored).}

\item{time}{The name of the column in the dataframe containing the (possibly
right-censored) follow-up times, that is, the minimum of the time of the
event and the time of censoring. Input the name as character/string.}

\item{event}{The name of the column in the dataframe containing the status
indicator, which must be coded as: 0 = censored, 1 = event observed. Input
the name as character/string.}

\item{K}{The number of intervals to be used in the piecewise exponential
(histogram) prior. Default is set to \eqn{K = (n / \log{n})^{1/2}}, with
\eqn{n} the number of observations, as recommended by Castillo and Van der
Pas (2020).}

\item{time.max}{The maximum follow-up time to consider, corresponding to the
parameter \eqn{tau} in Castillo and Van der Pas (2020).}
}
\value{
\item{failures}{A vector of length \eqn{K}, containing for each
interval the number of individuals who had an event during that interval.}
\item{exposures}{A vector of length \eqn{K}, containing for each interval
the total amount of time all individuals together were under follow-up
during that interval.}
}
\description{
To draw from the posterior of the piecewise exponential priors implemented
in this package, it is convenient to convert the data so that two vectors
are obtained: one containing the total amount of time all individuals
were under follow-up during each interval, and one containing the
number of events that happened during each interval. This function takes
a dataframe with a column of times (the minimum of the time of the event
and the time of censoring) and a column indicating the status (0 if censored,
1 if the event was observed) and reshapes it into the desired format. Most
users will not use this function directly, but will instead use the main
function \link{BayesSurv}, which uses the present function.
}
\references{
Castillo and Van der Pas (2020). Multiscale Bayesian survival
  analysis. <arXiv:2005.02889>.
}
\seealso{
\link{BayesSurv}, which computes the posterior mean and the
radius of the credible band for the cumulative hazard function as
well as the survival, and the posterior mean for the hazard. These objects
can then be visualized by using \link{PlotBayesSurv}.
}
