% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{crudeOR}
\alias{crudeOR}
\title{Model with constant nondifferential misclassification}
\usage{
crudeOR(a, N1, c, N0, se, sp, name = "Constant Misclassification Model",
  chains = 2, traceplot = FALSE, inc_warmup = FALSE, window = NULL,
  refresh = 0, seed = NA, ...)
}
\arguments{
\item{a}{# of exposed subjects in the case group.}

\item{N1}{# of total subjects in the case group.}

\item{c}{# of exposed subjects in the control group.}

\item{N0}{# of total subjects in the control group.}

\item{se}{sensitivity}

\item{sp}{specificity}

\item{name}{a string of the name of the model. Default to "Constant Misclassification Model".}

\item{chains}{number of Markov Chains. Default to 2.}

\item{traceplot}{Logical, defaulting to \code{FALSE}. If \code{TRUE} it will draw the 
\href{https://mc-stan.org/rstan/reference/stanfit-method-traceplot.html}{traceplot} corresponding to one or more Markov chains.}

\item{inc_warmup}{Only evaluated when \code{traceplot = TRUE}. \code{TRUE} or \code{FALSE}, indicating whether or not to include the warmup sample in the
traceplot; defaults to \code{FALSE}.}

\item{window}{Only evaluated when \code{traceplot = TRUE}. A vector of length 2. Iterations between \code{window[1]} and \code{window[2]} will be shown in the plot. 
The default shows all iterations if \code{inc_warmup} is \code{TRUE} and all iterations from the sampling period only if \code{inc_warmup} is \code{FALSE}. 
If \code{inc_warmup} is \code{FALSE} the iterations specified in \code{window} do not include iterations from the warmup period.
The default number of iterations is 2000 unless otherwise specified in the optional \code{iter} argument.}

\item{refresh}{an integer value used to control how often the progress of sampling is reported. By default, the progress indicator is turned off, thus refresh <= 0.
If on, refresh = max(iter/10, 1) is generally recommended.}

\item{seed}{the seed for random number generation. See \href{https://www.rdocumentation.org/packages/rstan/versions/2.17.3/topics/stan}{stan} for more details.}

\item{...}{optional parameters passed to \href{https://www.rdocumentation.org/packages/rstan/versions/2.17.3/topics/stan}{stan}.}
}
\value{
It returns a stanfit object of this model, which inherits stanfit class methods. See
\href{https://mc-stan.org/rstan/reference/stanfit-class.html}{here} for more details.
}
\description{
Generate a stanfit object corresponding to a posterior distribution of corrected odds ratio given nondifferential misclassification with crude Se and Sp (i.e., both are constant and at least one of Se or Sp is lower than 1).
}
\examples{
# Case-control study data of Bipolar Disorder with rheumatoid arthritis (Farhi et al. 2016)
# Data from \\url{https://www.sciencedirect.com/science/article/pii/S0165032715303864#bib13}\\
\donttest{
crudeOR(a = 66, N1 = 11782, c = 243, N0 = 57973, se = 0.744, sp = 0.755, chains = 3, 
iter = 10000, seed = 0)
crudeOR(a = 66, N1 = 11782, c = 243, N0 = 57973, se = 0.744, sp = 0.755, traceplot = TRUE)
}
}
