% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FactorQuery.R
\name{FactorQuery}
\alias{FactorQuery}
\title{Queries of discrete variable distributions}
\usage{
FactorQuery(tree, vars = c(), mode = c("joint", "conditional", "list"))
}
\arguments{
\item{tree}{a \code{clustertree} object}

\item{vars}{the variables to be queried}

\item{mode}{type of desired distribution}
}
\value{
\code{data.frame} object specifying a joint or conditional distribution.
}
\description{
Obtain the joint, marginal, and conditional distributions of discrete variables
}
\details{
Query the joint distribution of any combination of discrete variables when 
mode is "joint", or conditional distribution of a discrete variable. The mode "list"
return a \code{list} of variable combinations, such that joint distributions of any subset 
of them are ready for extraction. Queries outside this list are also supported but may 
take longer computing time. This function will also return marginal distribution if only
one variable is queried.
}
\examples{

data(chest)
dag <- chest$dag
node.class <- rep(TRUE, length(dag@nodes))
names(node.class) <- dag@nodes
cst <- ClusterTreeCompile(dag, node.class)
models <- LocalModelCompile(chest$data, dag, node.class)
tree.init <- ElimTreeInitialize(tree=cst$tree.graph, 
                                dag=cst$dag, 
                                model=models, 
                                node.sets=cst$cluster.sets, 
                                node.class=cst$node.class)
tree.init.p <- PropagateDBN(tree.init)
# get joint distribution
FactorQuery(tree=tree.init.p, vars=c("tub", "xray", "dysp", "asia"), mode="joint")

# get joint distribution
FactorQuery(tree=tree.init.p, vars=c("xray"), mode="conditional")

}
\author{
Han Yu
}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks. 
Journal of Machine Learning Research, 6(Sep), 1517-1550.
}

