% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode-finding.R
\name{find_mode}
\alias{find_mode}
\title{Find the MAP of a BNN using SGD}
\usage{
find_mode(bnn, optimiser, batchsize, epochs)
}
\arguments{
\item{bnn}{a BNN obtained using \code{\link{BNN}}}

\item{optimiser}{an optimiser. These start with `opt.`.
See for example \code{\link{opt.ADAM}}}

\item{batchsize}{batch size}

\item{epochs}{number of epochs to run for}
}
\value{
Returns a vector. Use \code{\link{posterior_predictive}}
to obtain a prediction using this MAP estimate.
}
\description{
Find the MAP of a BNN using SGD
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  find_mode(bnn, opt.RMSProp(), 10, 100)
}

}
