\name{makeClusterFunctionsInteractive}
\alias{makeClusterFunctionsInteractive}
\title{Create cluster functions for sequential execution in same session.}
\usage{
makeClusterFunctionsInteractive(write.logs = TRUE)
}
\arguments{
  \item{write.logs}{[\code{logical(1)}]\cr Sink the output
  to log files. Turning logging off can increase the speed
  of calculations but makes it next to impossible to debug.
  Default is \code{TRUE}.}
}
\value{
[\code{\link{ClusterFunctions}}].
}
\description{
All jobs executed under these cluster functions are
executed sequentially, in the same interactive R process
that you currently are. That is, \code{submitJob} does not
return until the job has finished. The main use of this
\code{ClusterFunctions} implementation is to test and debug
programs on a local computer.
}
\details{
Listing jobs returns an empty vector (as no jobs can be
running when you call this) and \code{killJob} returns at
once (for the same reason).
}

