context("batchExpandGrid")

test_that("batchExpandGrid", {
  reg = makeTestRegistry()
  batchExpandGrid(reg, function(x,y) x*y, 1:3, 5)
  submitJobs(reg)
  y = reduceResultsVector(reg, use.names=FALSE)
  expect_equal(y, (1:3) * 5)

  reg = makeTestRegistry()
  batchExpandGrid(reg, function(x,y) x*y, 1:3, 2:3)
  submitJobs(reg)
  y = reduceResultsVector(reg, use.names=FALSE)
  expect_equal(sum(y), sum(outer(1:3, 2:3)))

  reg = makeTestRegistry()
  batchExpandGrid(reg, function(x,y,z) x*y+z, 1:3, 5, more.args=list(z=10))
  submitJobs(reg)
  y = reduceResultsVector(reg, use.names=FALSE)
  expect_equal(y, ((1:3) * 5) + 10)
  
  reg = makeTestRegistry()
  batchExpandGrid(reg, function(x,y) paste(x,y), 1, c("a", "b"))
  submitJobs(reg)
  y = reduceResultsVector(reg, use.names=FALSE)
  expect_equal(y, c("1 a", "1 b"))
  
  reg = makeTestRegistry()
  batchExpandGrid(reg, function(x,y) x^y, y=2, x=1:3)
  submitJobs(reg)
  y = reduceResultsVector(reg, use.names=FALSE)
  expect_equal(y, (1:3)^2)
})