% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myGetSymbols.R
\name{myGetSymbols}
\alias{myGetSymbols}
\title{An improved version of function \code{\link[quantmod]{getSymbols}} from quantmod}
\usage{
myGetSymbols(
  ticker,
  i.ticker,
  length.tickers,
  src = "yahoo",
  first.date,
  last.date,
  do.cache = TRUE,
  cache.folder = file.path(tempdir(), "BGS_Cache"),
  df.bench = NULL,
  be.quiet = FALSE,
  thresh.bad.data
)
}
\arguments{
\item{ticker}{A single ticker to download data}

\item{i.ticker}{A index for the stock that is downloading (for cat() purposes)}

\item{length.tickers}{total number of stocks being downloaded (also for cat() purposes)}

\item{src}{The source of the data ('google' or'yahoo')}

\item{first.date}{The first date to download data (date or char as YYYY-MM-DD)}

\item{last.date}{The last date to download data (date or char as YYYY-MM-DD)}

\item{do.cache}{Use cache system? (default = TRUE)}

\item{cache.folder}{Where to save cache files? (default = file.path(tempdir(), 'BGS_Cache') )}

\item{df.bench}{Data for bechmark ticker}

\item{be.quiet}{Logical for printing statements (default = FALSE)}

\item{thresh.bad.data}{A percentage threshold for defining bad data. The dates of the benchmark ticker are compared to each asset. If the percentage of non-missing dates
with respect to the benchmark ticker is lower than thresh.bad.data, the function will ignore the asset (default = 0.75)}
}
\value{
A dataframe with the financial data
}
\description{
This is a helper function to \code{\link{BatchGetSymbols}} and it should normaly not be called directly. The purpose of this function is to download financial data based on a ticker and a time period.
The main difference from \code{\link[quantmod]{getSymbols}} is that it imports the data as a dataframe with proper named columns and saves data locally with the caching system.
}
\examples{
ticker <- 'FB'

first.date <- Sys.Date()-30
last.date <- Sys.Date()

\dontrun{
df.ticker <- myGetSymbols(ticker,
                          first.date = first.date,
                          last.date = last.date)
}
}
\seealso{
\link[quantmod]{getSymbols} for the base function
}
