% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concensus.identify.R
\name{consensus.identify}
\alias{consensus.identify}
\title{Consensus Identification}
\usage{
consensus.identify(identifiedBy2orMore)
}
\arguments{
\item{identifiedBy2orMore}{an object of class "data.frame", containing (queIDs, as rownames), identifiedByMethod1,identifiedByMethod2,and so on.}
}
\value{
a data frame with concensus.identification, and corresponding votes.
}
\description{
Make consensus for identifications from two or more methods, usually for 
a set of query sequences.
}
\note{
Suitable for case where a set of queries were identified by more than two methods.
}
\examples{

queIDs<-c("q1","q2","q3")

bp<-c("sp1","sp1","sp1")
bpk<-c("sp1","sp1","sp2")
bayes<-c("sp2","sp1","sp3")
fuzzyID<-c("sp1","sp1","sp2")
identifiedBy2orMore<-data.frame(bp=bp,bpk=bpk,bayes=bayes,fuzzyID=fuzzyID)
rownames(identifiedBy2orMore)<-queIDs<-c("q1","q2","q3")
ccs<-consensus.identify(identifiedBy2orMore)
}
\author{
Ai-bing ZHANG, PhD. CNU, Beijing, CHINA, contact at zhangab2008(at)mail.cnu.edu.cn
}
\keyword{consensus.identify}

