% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CP_model.R
\docType{class}
\name{CP_model}
\alias{CP_model}
\title{BaTFLED model object for 3-D response tensor with CP decomposition.}
\format{An \code{\link{R6Class}} generator object}
\usage{
CP_model
}
\description{
\code{CP_model} objects are 'R6' objects so that their values can be updated in place. 
The object is treated like an environment and components are accessed using the \code{$} 
operator. 
When creating a new CP_model object it will be populated with default values and empty matrices.
To initialize a \code{CP_model} call the \code{initialize()} method.
}
\section{Methods}{

\describe{
  \item{\code{new(data, params)}}{Creates a new \code{CP_model} object with
  matrices sized accoring to the matrices in \code{data}.}
  \item{\code{rand_init(params)}}{Initializes the \code{CP_model} with
  random values accoring to \code{params}.}
}
}
\examples{
data.params <- get_data_params(c('decomp=CP'))
toy <- mk_toy(data.params)
train.data <- input_data$new(mode1.X=toy$mode1.X[,-1],
                             mode2.X=toy$mode2.X[,-1],
                             mode3.X=toy$mode3.X[,-1],
                             resp=toy$resp)
model.params <- get_model_params(c('decomp=CP'))
toy.model <- mk_model(train.data, model.params)
toy.model$rand_init(model.params)
}
\seealso{
\code{get_model_params}, \code{input_data}, \code{Tucker_model}
}
\keyword{data}

