\name{summary.impprep}

\alias{summary.impprep}

\title{Summary methd for objects of class \sQuote{impprep}}

\description{Returns an overview of missing-data patterns, in particular of missing-by-design patterns.} 

\usage{\method{summary}{impprep}(object, nNames=10L,...)}

\arguments{
  \item{object}{An object generated by \code{rowimpPrep}.}
  \item{nNames}{Number of variable names per block to be printed (Default = 10).}
  \item{...}{Arguments to be passed to or from other functions.}
}

\details{
Returns the number of identified missing-data patterns, the first \code{nNames} variable names per block 
and the names of the completely observed variables.
}


\author{Florian Meinfelder}

\seealso{\code{\link{rowimpPrep}}}

\examples{

### sample data set with non-normal variables and a single
### missingness pattern
set.seed(1000)
n <- 50
x1 <- round(runif(n,0.5,3.5))
x2 <- as.factor(c(rep(1,10),rep(2,25),rep(3,15)))
x3 <- round(rnorm(n,0,3))
y1 <- round(x1-0.25*(x2==2)+0.5*x3+rnorm(n,0,1))
y1 <- ifelse(y1<1,1,y1)
y1 <- ifelse(y1>4,5,y1)
y2 <- y1+rnorm(n,0,0.5)
y3 <- round(x3+rnorm(n,0,2))
data1 <- as.data.frame(cbind(x1,x2,x3,y1,y2,y3))
misrow1 <- sample(n,20)
is.na(data1[misrow1, c(4:6)]) <- TRUE

### preparation step
impblock <- rowimpPrep(data1)

summary(impblock)
}
