% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeToTargetRunSize.r
\name{TimeToTargetRunSize}
\alias{TimeToTargetRunSize}
\title{Computes and plots posterior distribution of time to get target run size.
For example, the time to reach a cumulative run of 10,000 fish.}
\usage{
TimeToTargetRunSize(U, time, targetU, file_prefix, ci_prob = 0.95)
}
\arguments{
\item{U}{Elements of sim.list from MCMC object for U - the estimate runsize
in each stratum}

\item{time}{Vector of stratum time indices}

\item{targetU}{The targeted cumulative run size. E.g. 10,000}

\item{file_prefix}{Character string giving prefix for plot. A plot will be
produced of the posterior in the filename
paste(file_prefix,"-target.pdf",sep="")).}

\item{ci_prob}{What size of credible interval should be computed?}
}
\value{
A list with a sample of the posterior (index), quantiles
(quantiles), mean (mean), median(median), and standard deviation (sd), and
target value (targetU)
}
\description{
Takes a sim.list object from the MCMC runs, computes the posterior
distribution of the time to the target runsize, plots the posterior
#'
}
\examples{
 
\dontrun{
# Compute the posterior of time to reach 10,000 fish. Results contains the MCMC object
# 
results$TimeToTargetRunSize <- TimeToTargetRunSize( 
        U=results$sims.list$U,
        time=results$data$time,
        targetU=10000,
        file_prefix = 'Time10000')

} \% end of dontrun

}
\author{
Bonner, S.J. \email{sbonner6@uwo.ca} and 
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{~models}
\keyword{~plots}
