% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.BTLLasso.R
\name{response.BTLLasso}
\alias{response.BTLLasso}
\title{Create response object for BTLLasso}
\usage{
response.BTLLasso(response, first.object = NULL, second.object = NULL,
  subject = NULL)
}
\arguments{
\item{response}{Vector containing results (binary or ordinal) of single paired
comparisons. Alternatively, also a  \code{\link[psychotools]{paircomp}} object as defined 
in the package \code{psychotools} could be used. In this case, none of the further 
arguments are needed.}

\item{first.object}{Vector (character or factor, same length as response) indicating the first
object of the respective paired comparison from response.}

\item{second.object}{Vector (character or factor, same length as response) indicating the second
object of the respective paired comparison from response.}

\item{subject}{Vector (character, same length as response) indicating the subject that
generated the respective paired comparison from response.}
}
\value{
Object of class \code{response.BTLLasso}
}
\description{
Create a response object for \code{BTLLasso} and \code{cv.BTLLasso}
}
\examples{

\dontrun{
##############################
##### Example how response object for Bundesliga data Buli1516 was created
##############################

data(BuliResponse)

Y.Buli <- response.BTLLasso(response = BuliResponse$Result, 
                            first.object = BuliResponse$TeamHome,
                            second.object = BuliResponse$TeamAway,
                            subject = BuliResponse$Matchday)


##############################
##### Example to create response object from paircomp object
##############################
data("Topmodel2007", package = "psychotree")

Y.models <- response.BTLLasso(Topmodel2007$preference)
X.models <- scale(model.matrix(preference~., data = Topmodel2007)[,-1])
rownames(X.models) <- paste0("Subject",1:nrow(X.models))
colnames(X.models) <- c("Gender","Age","KnowShow","WatchShow","WatchFinal")

set.seed(5)
m.models <- cv.BTLLasso(Y = Y.models, X = X.models)
}
}
\references{
Schauberger, Gunther and Tutz, Gerhard (2017): Subject-specific modelling 
of paired comparison data: A lasso-type penalty approach, \emph{Statistical Modelling},
17(3), 223 - 243

Schauberger, Gunther, Groll Andreas and Tutz, Gerhard (2016): Modelling 
Football Results in the German Bundesliga Using Match-specific Covariates, 
\emph{Department of Statistics, LMU Munich}, Technical Report 197
}
\seealso{
\code{\link{BTLLasso}}, \code{\link{cv.BTLLasso}}
}
\author{
Gunther Schauberger\cr \email{gunther@stat.uni-muenchen.de}\cr
\url{http://www.semsto.statistik.uni-muenchen.de/personen/doktoranden/schauberger/index.html}
}
