% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_bspbss.R
\name{mcmc_bspbss}
\alias{mcmc_bspbss}
\title{MCMC algorithm for Bayesian spatial blind source separation
with the thresholded Gaussian Process prior.}
\usage{
mcmc_bspbss(
  X,
  init,
  prior,
  kernel,
  n.iter,
  n.burn_in,
  thin = 1,
  show_step,
  ep = 0.01,
  lr = 0.01,
  decay = 0.01,
  subsample_n = 0.5,
  subsample_p = 0.5
)
}
\arguments{
\item{X}{Data matrix with n rows (sample) and p columns (voxel).}

\item{init}{List of initial values, see \code{init_bspbss}.}

\item{prior}{List of priors, see \code{init_bspbss}.}

\item{kernel}{List including eigenvalues and eigenfunctions of the kernel, see \code{init_bspbss}.}

\item{n.iter}{Total iterations in MCMC.}

\item{n.burn_in}{Number of burn-in.}

\item{thin}{Thining interval.}

\item{show_step}{Frequency for printing the current number of iterations.}

\item{ep}{Approximation parameter.}

\item{lr}{Per-batch learning rate in SGHMC.}

\item{decay}{Decay parameter in SGHMC.}

\item{subsample_n}{Mini-batch size of samples.}

\item{subsample_p}{Mini-batch size of voxels.}
}
\value{
List containing MCMC samples of: A, b, sigma, and zeta.
}
\description{
Performan MCMC algorithm to draw samples from a Bayesian spatial blind source separation
model.
}
\examples{

sim = sim_2Dimage(length = 30, sigma = 5e-4, n = 30, smooth = 6)
ini = init_bspbss(sim$X, sim$coords, q = 3, ker_par = c(0.1,50), num_eigen = 50)
res = mcmc_bspbss(ini$X,ini$init,ini$prior,ini$kernel,n.iter=200,n.burn_in=100,thin=10,show_step=50)

}
