% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinePlotsBSL.R
\name{combinePlotsBSL}
\alias{combinePlotsBSL}
\title{Plot the densities of multiple ``bsl'' class objects.}
\usage{
combinePlotsBSL(objectList, which = 1L, thin = 1, thetaTrue = NULL,
  label = NULL, legendPosition = c("auto", "right", "bottom")[1],
  legendNcol = NULL, col = NULL, lty = NULL, lwd = NULL,
  cex.lab = 1, cex.axis = 1, cex.legend = 0.75,
  top = "Approximate Marginal Posteriors", options.color = list(),
  options.linetype = list(), options.size = list(),
  options.theme = list())
}
\arguments{
\item{objectList}{A list of ``bsl'' class objects.}

\item{which}{An integer argument indicating which plot function to be used. The default, \code{1L}, uses
the plain \code{plot} to visualise the result. \code{2L} uses ggplot2 to draw the plot.}

\item{thin}{A numeric argument indicating the gap between samples to be taken when thinning the MCMC
draws. The default is \code{1}, which means no thinning is used.}

\item{thetaTrue}{A set of values to be included on the plots as a reference line. The default is \code{NULL}.}

\item{label}{A string vector indicating the labels to be shown in the plot legend. The default is
\code{NULL}, which uses the names from \code{objectList}.}

\item{legendPosition}{One of the three string arguments, ``auto'', ``right'' or ``bottom'', indicating the legend
position. The default is ``auto'', which automatically choose from ``right'' and ``bottom''. Only used when
\code{which} is \code{1L}.}

\item{legendNcol}{A integer argument indicating the number of columns of the legend. The default,
\code{NULL}, put all legends in the same row or column depending on \code{legendPosition}. Only used when
\code{which} is \code{1L}.}

\item{col}{A vector argument containing the plotting color for each density curve. Each element of
the vector will be passed into \code{lines}. Only used when \code{which} is \code{1L}.}

\item{lty}{A vector argument containing the line type for each density curve. Each element of
the vector will be passed into \code{lines}. Only used when \code{which} is \code{1L}.}

\item{lwd}{A vector argument containing the line width for each density curve. Each element of
the vector will be passed into \code{lines}. Only used when \code{which} is \code{1L}.}

\item{cex.lab}{The magnification to be used for x and y labels relative to the current setting of cex.
To be passed into \code{plot}. Only used when \code{which} is \code{1L}.}

\item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex.
To be passed into \code{plot}. Only used when \code{which} is \code{1L}.}

\item{cex.legend}{The magnification to be used for legend annotation relative to the current setting of cex.
Only used when \code{which} is \code{1L}.}

\item{top}{A string argument of the combined plot title. Only used when \code{which} is \code{2L}.}

\item{options.color}{A list of additional arguments to pass into function \code{ggplot2::scale_color_manual}.
Only used when \code{which} is \code{2L}.}

\item{options.linetype}{A list of additional arguments to pass into function \code{ggplot2::scale_linetype_manual}.
Only used when \code{which} is \code{2L}.}

\item{options.size}{A list of additional arguments to pass into function \code{ggplot2::scale_size_manual}.
Only used when \code{which} is \code{2L}.}

\item{options.theme}{A list of additional arguments to pass into the \code{theme} function. Only use
when \code{which} is \code{2L}.}
}
\description{
The function \code{combinePlotsBSL} can be used to plot multiple BSL densities together, optionally
with the true values for the parameters.
}
\seealso{
\code{\link{ma2}} for an example
}
