% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Simpson}
\alias{Simpson}
\title{Grade point averages of men and women participating in various sports-an
illustration of Simpson's paradox}
\format{
A data frame/tibble with 100 observations on three variables
\describe{ 
\item{gpa}{grade point average} 
\item{sport}{sport played (basketball, soccer, or track)} 
\item{gender}{athlete sex (male, female)}
}
}
\usage{
Simpson
}
\description{
Data for Example 1.18
}
\examples{

boxplot(gpa ~ gender, data = Simpson, col = "violet")
boxplot(gpa ~ sport, data = Simpson, col = "lightgreen")
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Simpson, aes(x = gender, y = gpa, fill = gender)) +
           geom_boxplot() + 
           facet_grid(.~sport) + 
           theme_bw()
}
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
