% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Monoxide}
\alias{Monoxide}
\title{Carbon monoxide emitted by smoke stacks of a manufacturer and a competitor}
\format{A data frame/tibble with ten observations on two variables
\describe{ 
\item{company}{a vector with values \code{manufacturer} and \code{competitor}} 
\item{emission}{carbon monoxide emitted} 
}}
\usage{
Monoxide
}
\description{
Data for Exercise 7.45
}
\examples{

boxplot(emission ~ company, data = Monoxide, col = topo.colors(2))
t.test(emission ~ company, data = Monoxide)
wilcox.test(emission ~ company, data = Monoxide)
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Monoxide, aes(x = company, y = emission)) + 
           geom_boxplot() + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
