% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Indy500}
\alias{Indy500}
\title{Qualifying miles per hour and number of previous starts for drivers in 79th
Indianapolis 500 race}
\format{A data frame/tibble with 33 observations on four variables
\describe{ 
\item{driver}{a character variable with values \code{andretti},
\code{bachelart}, \code{boesel}, \code{brayton}, \code{c.guerrero},
\code{cheever}, \code{fabi}, \code{fernandez}, \code{ferran}, \code{fittipaldi},
\code{fox}, \code{goodyear}, \code{gordon}, \code{gugelmin}, \code{herta},
\code{james}, \code{johansson}, \code{jones}, \code{lazier}, \code{luyendyk},
\code{matsuda}, \code{matsushita}, \code{pruett}, \code{r.guerrero},
\code{rahal}, \code{ribeiro}, \code{salazar}, \code{sharp}, \code{sullivan},
\code{tracy}, \code{vasser}, \code{villeneuve}, and \code{zampedri}}
\item{qualif}{qualifying speed (in mph)} 
\item{starts}{number of Indianapolis 500 starts} 
\item{group}{a numeric vector where 1 indicates the driver has 4 or fewer 
Indianapolis 500 starts and a 2 for drivers with 5 or more Indianapolis 500 starts} 
}}
\usage{
Indy500
}
\description{
Data for Exercises 7.11 and 7.36
}
\examples{

stripchart(qualif ~ group, data = Indy500, method = "stack",
           pch = 19, col = c("red", "blue"))
boxplot(qualif ~ group, data = Indy500)
t.test(qualif ~ group, data = Indy500)
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Indy500, aes(sample = qualif)) + 
           geom_qq() + 
           facet_grid(group ~ .) + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
