% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{German}
\alias{German}
\title{Number of errors in copying a German passage before and after an
experimental course in German}
\format{A data frame/tibble with ten observations on three variables
\describe{ 
\item{student}{a character variable indicating student number} 
\item{when}{a character variable with values \code{Before} and \code{After} 
to indicate when the student received experimental instruction in German}
\item{errors}{the number of errors in copying a German passage}
}}
\usage{
German
}
\description{
Data for Exercise 7.60
}
\examples{

t.test(errors ~ when, data = German, paired = TRUE)
wilcox.test(errors ~ when, data = German)

\dontrun{
T8 <- tidyr::spread(German, when, errors) \%>\%
mutate(di = After - Before, adi = abs(di), rk = rank(adi), srk = sign(di)*rk)
T8
qqnorm(T8$di)
qqline(T8$di)
t.test(T8$srk)
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
