% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Aids}
\alias{Aids}
\title{Incubation times for 295 patients thought to be infected with HIV by a blood
transfusion}
\format{A data frame/tibble with 295 observations on three variables
\describe{ 
\item{duration}{time (in months) from HIV infection to the clinical manifestation of full-blown AIDS} 
\item{age}{age (in years) of patient} 
\item{group}{a numeric vector}
}}
\source{
Kalbsleich, J. and Lawless, J., (1989), An analysis of the data on transfusion
related AIDS, \emph{Journal of the American Statistical Association, 84}, 360-372.
}
\usage{
Aids
}
\description{
Data used in Exercise 6.60
}
\examples{

with(data = Aids,
EDA(duration)
)
with(data = Aids, 
     t.test(duration, mu = 30, alternative = "greater")
)
with(data = Aids, 
     SIGN.test(duration, md = 24, alternative = "greater")
)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
