% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustCells.R
\name{adjustCells}
\alias{adjustCells}
\title{Adjust for estimated cell type proportions in bulk gene expression data.}
\usage{
adjustCells(inputMat, cellSPV, celltypes = NULL, addMeans = FALSE,
  formula = NULL, verbose = FALSE)
}
\arguments{
\item{inputMat}{Input gene expression data, with rows as features (e.g. genes) and samples as columns.}

\item{cellSPV}{Estimated matrix of surrogate proportion variables for each cell type, with samples as rows and columns as cell types.}

\item{celltypes}{Character vector of which cell types to use. Must correspond to column names in the cellSPV data frame. If NULL, all of the columns of SPV will be used for adjustment.}

\item{addMeans}{Whether the mean should be added to the residuals in the resulting adjusted gene expression table.}

\item{formula}{If you want to add additional covariates to be adjusted for, then you can supply them by adding an (optional) formula function here. The format should be "expression_data ~ $cov1 + factor($cov2) +", where $cov1 is a numeric covariate present in the current environment, and $cov2 is a factor variable also defined in the current environment.}

\item{verbose}{Whether to print out the formula used for adjustment of each row.}
}
\value{
A matrix of adjusted gene expression values.
}
\description{
This function uses a linear model to adjust each row of gene expression for cell types, taking the residuals from the linear model for downstream analysis. Other covariates can be included as well, if they are defined in the current environment, through the use of the formula argument.
}
\examples{
\donttest{
svp_res = brainCells(inputMat = aba_marker_expression, nMarker = 10,
  species = "human", celltypes = c("ast", "neu", "oli"))
str(svp_res)
adjust_res = adjustCells(inputMat = aba_marker_expression,
  cellSPV = svp_res, addMeans = FALSE)
str(adjust_res)
}
}
