% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.mtd.R
\name{select.mtd}
\alias{select.mtd}
\title{Select the maximum tolerated dose (MTD) for single agent trials}
\usage{
select.mtd(target, npts, ntox, cutoff.eli=0.95, extrasafe=FALSE, offset=0.05,
                 boundMTD=FALSE,p.tox=1.4*target)
}
\arguments{
\item{target}{the target DLT rate}

\item{npts}{a vector containing the number of patients treated at each dose level}

\item{ntox}{a vector containing the number of patients who experienced dose-limiting
toxicity at each dose level}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of (\code{cutoff.eli=0.95}) for general use.}

\item{extrasafe}{set \code{extrasafe=TRUE} to impose a more strict stopping rule for
extra safety}

\item{offset}{a small positive number (between \code{0} and \code{0.5}) to control how strict the
stopping rule is when \code{extrasafe=TRUE}. A larger value leads to
a more strict stopping rule. The default value \code{offset=0.05}
generally works well.}

\item{boundMTD}{set \code{boundMTD=TRUE} to impose the condition: the isotonic estimate of toxicity
probability for the selected MTD must be less than de-escalation boundary.}

\item{p.tox}{the lowest toxicity probability that is deemed overly toxic such
that deescalation is required. The default value is
  \code{p.tox=1.4*target}.}
}
\value{
\code{select.mtd()} returns (1) target toxicity probability (\code{$target}), (2) selected MTD (\code{$MTD}),
(3) isotonic estimate of the DLT probablity at each dose and associated \eqn{95\%} credible interval (\code{$p_est}),
and (4) the probability of overdosing defined as \eqn{Pr(toxicity>\code{target}|data)} (\code{$p_overdose})
}
\description{
Select the maximum tolerated dose (MTD) when the single-agent trial is completed
}
\details{
\code{select.mtd()} selects the MTD based on isotonic estimates of toxicity
         probabilities. \code{select.mtd()} selects as the MTD dose \eqn{j^*}, for which the
         isotonic estimate of the DLT rate is closest to the target. If there
         are ties, we select from the ties the highest dose level when the estimate
         of the DLT rate is smaller than the target, or the lowest dose level
         when the estimate of the DLT rate is greater than the target. The
         isotonic estimates are obtained by the pooled-adjacent-violators algorithm
         (PAVA) (Barlow, 1972).
}
\note{
The MTD selection and dose escalation/deescalation rule are two independent
       components of the trial design. When appropriate, another dose selection
       procedure (e.g., based on a fitted logistic model) can be used to select
       the MTD after the completion of the trial using the BOIN design.
}
\examples{

### select the MTD for BOIN single agent trial
n <- c(3, 3, 15, 9, 0)
y <- c(0, 0, 4, 4, 0)
selmtd <- select.mtd(target=0.3, npts=n, ntox=y)
summary(selmtd)
plot(selmtd)

}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for
           Phase I Clinical Trials, \emph{Journal of the Royal Statistical Society:
           Series C}, 64, 507-523.

           Yan, F., Zhang, L., Zhou, Y., Pan, H., Liu, S. and Yuan, Y. (2020).BOIN: An R Package
           for Designing Single-Agent and Drug-Combination Dose-Finding Trials Using Bayesian Optimal
           Interval Designs. \emph{Journal of Statistical Software}, 94(13),1-32.<doi:10.18637/jss.v094.i13>.


            Yuan Y., Hess K.R., Hilsenbeck S.G. and Gilbert M.R. (2016). Bayesian Optimal Interval Design: A
       Simple and Well-performing Design for Phase I Oncology Trials, \emph{Clinical Cancer Research}, 22, 4291-4301.
}
\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN2.6_tutorial.pdf}

Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}
\author{
Suyu Liu, Yanhong Zhou, and Ying Yuan
}
