\name{get.oc}
\alias{get.oc}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
%%  ~~function to do ... ~~
Generate operating characteristics
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Obtain the operating characteristics of the BOIN design by simulating trials. 
}
\usage{
get.oc(target, p.true, ncohort, cohortsize, n.earlystop=100, startdose=1, 
p.saf="default", p.tox="default", design = 1, cutoff.eli = 0.95, 
extrasafe = FALSE, offset = 0.05, ntrial = 1000)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{target}{
%%     ~~Describe \code{target} here~~
target toxicity rate
}
  \item{p.true}{
%%     ~~Describe \code{p.true} here~~
a vector containing the true toxicity probabilities of the investigational dose levels.
}
  \item{ncohort}{
%%     ~~Describe \code{ncohort} here~~
the total number of cohorts
}
  \item{cohortsize}{
%%     ~~Describe \code{cohortsize} here~~
the cohort size
}

 \item{n.earlystop}{
%%     ~~Describe \code{ndmax} here~~
Early stopping parameter. If the number of patients treated at the current dose reaches \code{n.earlystop}, stop the trial and select the MTD based on the observed data. The default value \code{n.earlystop=100} essentially turns off this type of early stopping. 
}


  \item{startdose}{
%%     ~~Describe \code{startdose} here~~
the starting dose level for the trial
}
  \item{p.saf}{
%%     ~~Describe \code{p.saf} here~~
the highest toxicity probability that is deemed subtherapeutic (i.e. below the MTD) such that dose escalation should be undertaken. The default value is \code{p.saf=0.6 x target}.}
  \item{p.tox}{
%%     ~~Describe \code{p.tox} here~~
the lowest toxicity probability that is deemed overly toxic such that deescalation is required. The default value is \code{p.tox=1.4 x target}.
}
  \item{design}{
%%     ~~Describe \code{design} here~~
to use the local optimal design (the default, \code{design=1}) or the global optimal design (\code{design=2}).
}
  \item{cutoff.eli}{
%%     ~~Describe \code{cutoff.eli} here~~
the cutoff to eliminate an overly toxic dose for safety. We recommend the default value of \code{(cutoff.eli=0.95)} for general use 
}
  \item{extrasafe}{
%%     ~~Describe \code{ntrial} here~~
set \code{extrasafe=TRUE} to impose a more stringent stopping rule
}
  \item{offset}{
%%     ~~Describe \code{ntrial} here~~
a small positive number (between 0 and 0.5) to control how strict the stopping rule is when \code{extrasafe=TRUE}. A larger value leads to a more strict stopping rule. The default value \code{offset=0.05} generally works well.
}
  \item{ntrial}{
%%     ~~Describe \code{ntrial} here~~
the total number of trials to be simulated. 
}
}
\details{
The operating characteristics of the BOIN design are generated by simulating trials under the prespecified  true toxicity probabilities of the investigational doses. The BOIN design has two built-in stopping rules: (1) stop the trial if the lowest dose is eliminated due to toxicity, and no dose should be selected as the MTD; and (2) stop the trial and select the MTD if the number of patients treated at the current dose reaches \code{n.earlystop}. The first stopping rule is a safety rule to protect patients from the case in which all doses are overly toxic. The rationale for the second stopping rule is that when there is a large number (i.e., \code{n.earlystop}) of patients assigned to a dose, it means that the dose-finding algorithm has approximately converged. Thus, we can stop the trial early and select the MTD to save sample size and reduce the trial duration.  

For some applications, investigators may prefer a more strict safety stopping rule than rule (1) for extra safety when the lowest dose is overly toxic. This can be achieved by setting \code{extrasafe=TRUE}, which imposes the following more strict safety stopping rule: stop the trial if (i) the number of patients treated at the lowest dose >=3, and (ii) Pr(toxicity rate of the lowest dose > \code{target} | data) > \code{cutoff.eli-offset}. As a tradeoff, the strong stopping rule will decrease the MTD selection percentage when the lowest dose actually is the MTD.
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
\code{get.oc} returns the operating characteristics of the BOIN design as a data frame, including (1) function arguments (1) selection percentage at each dose level (selpercent), (2) the number of patients treated at each dose level (nptsdose), (3) the number of toxicities observed at each dose level (ntoxdose), (4) the average number of toxicities (totaltox), (5) the average number of patients (totaln), and (6) the percentage of early stopping without selecting the MTD (pctearlystop). 
}

\references{
%% ~put references to the literature/web site here ~
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical Trials, \emph{Journal of the Royal Statistical Society: Series C}, 64, 507-523.
}

\author{
Suyu Liu and Ying Yuan (yyuan@mdanderson.org)
}

\note{
%%  ~~further notes~~
We recommend using the local BOIN design (i.e., the default option) because of its better operating characteristics and simplicity. We should avoid setting the values of \code{p.saf} and \code{p.tox} very close to the \code{target}. This is because the small sample sizes of typical phase I trials prevent us from differentiating the target toxicity rate from the rates close to it. In addition, in most clinical applications, the target toxicity rate is often a rough guess, and finding a dose level with a toxicity rate reasonably close to the target rate will still be of interest to the investigator. The default values provided by \code{get.boundary} are generally reasonable for most clinical applications.  
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN1.2_tutorial.pdf}

Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}

\examples{
## Consider a phase I trial aiming to find the MTD with a target toxicity rate of 0.3 
## the maximum sample size is 25 patients in cohort size of 1
## assume the true toxicity rates of 5 doses are (0.05, 0.15, 0.3, 0.45, 0.6)
## run 1,000 simulated trials
ptox = c(0.05, 0.15, 0.3, 0.45, 0.6)
get.oc(target=0.3, p.true=ptox, ncohort=25, cohortsize=1, ntrial=1000)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ operating characteristics }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
