% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condMCMC.R
\name{condMCMC}
\alias{condMCMC}
\title{MCMC for univariate Pitman-Yor mixtures}
\usage{
condMCMC(data, grid = NULL, niter, nburn, m0 = NULL, k0 = NULL,
  a0 = NULL, b0 = NULL, mass = 1, method = "ICS", napprox = 100,
  nupd = 1000, out_param = F, out_dens = TRUE, process = "DP",
  sigma_PY = 0, print_message = TRUE)
}
\arguments{
\item{data}{A dataset (vector).}

\item{grid}{A grid of points to evaluate the estimated density (vector).}

\item{niter}{Number of iterations to estimate the model.}

\item{nburn}{Number of burn-in iterations.}

\item{m0}{Mean of the location component of the base measure.}

\item{k0}{Tuning parameter of the variance for the location component of the base measure.}

\item{a0}{Shape parameter of the scale component of the base measure.}

\item{b0}{Rate parameter of the scale component of the base measure.}

\item{mass}{Mass parameter.}

\item{method}{Different methods to estimate the model. Possible vaule "ICS", "SLI" or "MAR",
importance conditional sampler/slice sampler/marginal sampler, default "ICS".}

\item{napprox}{Number of values to be sampled from the restricted process via "ICS" method, default 100.}

\item{nupd}{How frequently show the curren state of the estimation (number of iterations) - default 1000.}

\item{out_param}{If TRUE, save the parameters for each iteration, default FALSE.}

\item{out_dens}{If TRUE, return also the estimated density, default TRUE.}

\item{process}{Dirichlet process ("DP") or Pitman-Yor process ("PY"), default "DP".}

\item{sigma_PY}{Discount parameter of the Pitman-Yor process, default 0.}

\item{print_message}{If TRUE print the status of the estimation, default TRUE.}
}
\value{
A modCond class object contain the estimated density for each iterations,
the allocations for each iterations. If out_param is TRUE, also the parameters for each iteration.
}
\description{
The condMCMC function estimate a univariate Pitman-Yor process mixture model
with Gaussian kernel. Three possible sampling strategies: importance conditional sampler,
slice sampler and marginal sampler.

The models are of the form \deqn{\tilde f(x) = \int k(x; \mu, \sigma^2) \tilde p (d \mu, d \sigma^2)} where
\eqn{k(x; \mu, \sigma^2)} is an univariate gaussian kernel function, \eqn{\tilde p} is distributed as a Pitman-Yor
process with total mass \eqn{\vartheta}, discount parameter \eqn{\sigma} and normal-inverse-gamma base measure \eqn{P_0}, i.e.
\deqn{P_0 \sim N(\mu; m_0, k_0 \sigma^2) \times IG(\sigma^2; a_0, b_0).}
}
\examples{
data_toy <- c(rnorm(100, -3, 1), rnorm(100, 3, 1))
grid <- seq(-7, 7, length.out = 50)
est_model <- condMCMC(data = data_toy, grid = grid, niter = 1000,
                      nburn = 100, napprox = 100, nupd = 100)
summary(est_model)
plot(est_model)

}
