% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF_plots.R
\name{plotGOF_censored}
\alias{plotGOF_censored}
\title{Plot Goodness of fits graphical checks for censored data}
\usage{
plotGOF_censored(fit, qq_plot = FALSE, thinning_to = 500)
}
\arguments{
\item{fit}{The result of the fit, obtained through the function MixNRMI1 or MixNRMI2, MixNRMI1cens or MixNRMI2cens}

\item{qq_plot}{Whether to compute the QQ-plot}

\item{thinning_to}{How many iterations to compute the mean posterior quantiles}
}
\value{
A density plot, a cumulative density plot with the Turnbull cumulative distribution, and a percentile-percentile plot.
}
\description{
Plot Goodness of fits graphical checks for censored data
}
\examples{
set.seed(150520)
data(salinty)
out <- MixNRMI1cens(salinity$left, salinity$right, extras = TRUE, Nit = 100)
BNPdensity:::plotGOF_censored(out)
}
