% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{get_histogram_with_post_mean}
\alias{get_histogram_with_post_mean}
\title{Duration Times Plots: Histogram of duration times with Estimated Posterior Mean}
\usage{
get_histogram_with_post_mean(
  results,
  x_range = c(min(results$Duration_Times), max(results$Duration_Times)),
  breaks = (max(results$Duration_Times) - min(results$Duration_Times)) *
    length(results$Duration_Times)^(1/3)/2/IQR(results$Duration_Times)
)
}
\arguments{
\item{results}{results of duration times, i.e., results_duration}

\item{x_range}{custom range for x-axis; default is (min(durations),max(durations))}

\item{breaks}{custom breaks for the histogram; default breaks follows the Freedman-Diaconis rule, which would be (max(durations)-min(durations))*n^(1/3)/2/IQR(durations)}
}
\value{
No return value, called for plotting histogram superimposed with the posterior distribution of mixture gamma.
}
\description{
Plots the histogram of Duration Times superimposed the posterior mean mixture gamma distribution
}
\examples{
results <- BMRMM(foxp2_sm,num_cov=2,simsize=50)
get_histogram_with_post_mean(results$results_duration,x_range=c(0,2),breaks=50)
}
