## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(BMEmapping)

## -----------------------------------------------------------------------------
data("utsnowload")
head(utsnowload)

## ----eval=FALSE---------------------------------------------------------------
# ?utsnowload

## -----------------------------------------------------------------------------
# prediction location
x <- utsnowload[228:232, c("latitude", "longitude")]
x

## -----------------------------------------------------------------------------
# hard data locations
ch <- utsnowload[1:67, c("latitude", "longitude")] 

# soft data locations
cs <- utsnowload[68:227, c("latitude", "longitude")]  

# hard data values
zh <- utsnowload[1:67, c("hard")]

# lower bounds
a <- utsnowload[68:227, c("lower")] 

# upper bounds
b <- utsnowload[68:227, c("upper")] 


## -----------------------------------------------------------------------------
# variogram model and parameters
model <- "exp"
nugget <- 0.0953
sill <- 0.3639
range <- 1.0787

## ----fig.width = 4, fig.height = 4.5, fig.align='center'----------------------
prob_zk(x[1,], ch, cs, zh, a, b, model, nugget, sill, range,  plot = TRUE)

## -----------------------------------------------------------------------------
# posterior mode
bme_predict(x, ch, cs, zh, a, b, model, nugget, sill, range, type = "mode")

# posterior mean
bme_predict(x, ch, cs, zh, a, b, model, nugget, sill, range, type = "mean")

## ----eval=FALSE---------------------------------------------------------------
# bme_cv(ch, cs, zh, a, b, model, nugget, sill, range, type = "mean")
# 
# #> $results
# #>    latitude longitude    observed    mean variance residual fold
# #> 1     40.44   -112.24  0.09696012 -0.2065   0.3598   0.3035    1
# #> 2     39.94   -112.41  0.12258678 -0.3423   0.3427   0.4649    2
# #> 3     37.51   -113.40 -0.02302358 -0.0726   0.3514   0.0496    3
# #> 4     37.49   -113.85  0.50354362 -0.1631   0.3900   0.6666    4
# #> 5     39.31   -109.53 -0.68611327 -0.2303   0.4444  -0.4558    5
# #> 6     40.72   -109.54 -0.53000397 -0.7366   0.3024   0.2066    6
# #> 7     40.61   -109.89 -0.71923519 -0.8916   0.3152   0.1724    7
# #> 8     40.91   -109.96 -1.31503404 -1.0151   0.2933  -0.2999    8
# #> 9     40.74   -109.67 -0.94879597 -0.7044   0.2795  -0.2444    9
# #> 10    40.92   -110.19 -1.39798035 -1.0139   0.3175  -0.3841   10
# #> 11    40.95   -110.48 -1.21900906 -0.9611   0.2218  -0.2579   11
# #> 12    40.60   -110.43 -1.24787225 -0.8706   0.2713  -0.3773   12
# #> 13    40.55   -110.69 -0.55027484 -0.6954   0.2599   0.1451   13
# #> 14    40.91   -110.50 -1.06708711 -1.0866   0.2119   0.0195   14
# #> 15    40.72   -110.47 -1.14044998 -0.9950   0.2578  -0.1454   15
# #> 16    40.58   -110.59 -0.94551554 -0.8009   0.2416  -0.1446   16
# #> 17    40.86   -110.80 -0.83840015 -0.5465   0.2681  -0.2919   17
# #> 18    40.77   -110.01 -1.24671792 -1.0531   0.2734  -0.1936   18
# #> 19    40.80   -110.88 -0.65036211 -0.4763   0.2321  -0.1741   19
# #> 20    40.68   -110.95 -0.37127802 -0.4399   0.2586   0.0686   20
# #> 21    39.89   -110.75 -0.80367306 -0.3605   0.3668  -0.4432   21
# #> 22    39.96   -110.99 -0.54230365 -0.2677   0.2912  -0.2746   22
# #> 23    41.38   -111.94  0.94099563  0.7969   0.1807   0.1441   23
# #> 24    41.31   -111.45  0.24796667  0.0273   0.2867   0.2207   24
# #> 25    41.41   -111.83  0.47642403  0.6856   0.2460  -0.2092   25
# #> 26    41.38   -111.92  1.25233814  0.6507   0.1735   0.6016   26
# #> 27    41.90   -111.63  0.61655171  0.0339   0.3443   0.5827   27
# #> 28    41.68   -111.42  0.18443361 -0.0173   0.3117   0.2017   28
# #> 29    41.41   -111.54  0.11223798  0.2098   0.2246  -0.0976   29
# #> 30    41.47   -111.50  0.10561343  0.1328   0.2329  -0.0272   30
# #> 31    40.85   -111.05 -0.10690304 -0.3160   0.1908   0.2091   31
# #> 32    40.89   -111.07 -0.29946212 -0.2456   0.2007  -0.0539   32
# #> 33    40.16   -111.21  0.00344554 -0.1387   0.3134   0.1421   33
# #> 34    40.99   -111.82  0.78786432  0.0856   0.2765   0.7023   34
# #> 35    40.43   -111.62  0.39822325  0.0749   0.2780   0.3233   35
# #> 36    40.36   -111.09 -0.24414027 -0.2252   0.3183  -0.0189   36
# #> 37    40.61   -111.10 -0.52669066 -0.2218   0.2720  -0.3049   37
# #> 38    40.76   -111.63  0.14568497  0.2201   0.2832  -0.0744   38
# #> 39    40.79   -111.12 -0.10923301 -0.3191   0.2304   0.2099   39
# #> 40    39.68   -111.32 -0.08382941 -0.2960   0.2652   0.2122   40
# #> 41    39.31   -111.43 -0.78984433 -0.4473   0.2903  -0.3425   41
# #> 42    39.14   -111.56 -0.38648680 -0.6416   0.2396   0.2551   42
# #> 43    39.05   -111.47 -0.57739062 -0.5946   0.2228   0.0172   43
# #> 44    39.87   -111.28 -0.22947205 -0.0731   0.1994  -0.1564   44
# #> 45    39.89   -111.25 -0.03805984 -0.1976   0.2003   0.1595   45
# #> 46    39.45   -111.27 -0.42606551 -0.4756   0.3043   0.0495   46
# #> 47    39.13   -111.44 -0.52777166 -0.5962   0.2269   0.0684   47
# #> 48    39.01   -111.58 -0.81486819 -0.4973   0.2491  -0.3176   48
# #> 49    39.93   -111.63  0.06849776 -0.0867   0.2983   0.1552   49
# #> 50    38.77   -111.68 -0.68746363 -0.6272   0.1908  -0.0603   50
# #> 51    38.68   -111.60 -1.04793061 -0.6279   0.2834  -0.4200   51
# #> 52    38.21   -111.48 -1.40848147 -0.6012   0.3933  -0.8073   52
# #> 53    38.80   -111.68 -0.43759896 -0.7310   0.1964   0.2934   53
# #> 54    37.84   -111.88 -0.73581358 -0.4816   0.4018  -0.2542   54
# #> 55    38.51   -112.02 -0.90807705 -0.7382   0.3365  -0.1699   55
# #> 56    38.48   -112.39 -0.67118202 -0.6298   0.2905  -0.0414   56
# #> 57    38.30   -112.36 -0.76527983 -0.5643   0.2435  -0.2010   57
# #> 58    38.30   -112.44 -0.51835705 -0.5553   0.2232   0.0369   58
# #> 59    38.88   -112.25 -0.24704072 -0.4462   0.3438   0.1992   59
# #> 60    37.58   -112.90 -0.42302609 -0.3781   0.2050  -0.0449   60
# #> 61    37.49   -112.58  0.00732065 -0.1742   0.2318   0.1815   61
# #> 62    37.49   -112.51  0.02427501 -0.1263   0.2205   0.1506   62
# #> 63    37.66   -112.74 -0.76376457 -0.3345   0.2746  -0.4293   63
# #> 64    37.57   -112.84 -0.28791382 -0.4501   0.2057   0.1622   64
# #> 65    37.53   -113.05 -0.07280592 -0.3232   0.2927   0.2504   65
# #> 66    38.48   -109.27 -0.90950964 -0.3653   0.3869  -0.5442   66
# #> 67    37.81   -109.49 -0.39635792 -0.3522   0.3680  -0.0442   67
# #>
# #> $metrics
# #> ME    MAE   RMSE
# #> 1 -0.0102 0.2378 0.2953

