% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateBLP.R
\name{estimateBLP}
\alias{estimateBLP}
\title{Performs a BLP demand estimation.}
\usage{
estimateBLP(blp_data, par_theta2, solver_method = "BFGS",
  solver_maxit = 10000, solver_reltol = 1e-06,
  standardError = "heteroskedastic", extremumCheck = FALSE,
  printLevel = 2, ...)
}
\arguments{
\item{blp_data}{data object created by the function \code{BLP_data},}

\item{par_theta2}{matrix with column and rownames providing a starting value for the optimization routine (see details),}

\item{solver_method}{character specifying the solver method in \code{optim} (further arguments can be passed to \code{optim} by ...)}

\item{solver_maxit}{integer specifying maximum iterations for the optimization routine (default=10000),}

\item{solver_reltol}{integer specifying tolerance for the optimization routine (default= 1e-6),}

\item{standardError}{character specifying assumptions about the GMM residual (homoskedastic , heteroskedastic (default), or cluster)}

\item{extremumCheck}{if \code{TRUE}, second derivatives are checked for the existence of minimum at the point estimate (default = FALSE),}

\item{printLevel}{level of output information ranges from 0 (no GMM results) to 4 (every norm in the contraction mapping)}

\item{...}{additional arguments for \code{optim}}
}
\value{
Returns an object of class "blp_est". This object contains, among others, all estimates for preference parameters and standard errors.
}
\description{
Performs a BLP demand estimation.
}
\details{
NA's in \code{par_theta2} entries indicate the exclusion from estimation, i.e. the coefficient is assumed to be zero.
If only unobserved heterogeneity is used (no demographics), the column name of \code{par_theta2} must be "unobs_sd".
With demographics the colnames must match the names of provided demographics (as in \code{demographic_draws}) and "unobs_sd".
Row names of \code{par_theta2} must match random coefficients as specified in \code{model}. Constants must be named "(Intercept)".
}
\examples{
K<-2 #number of random coefficients
data <- simulate_BLP_dataset(nmkt = 25, nbrn = 20,
                        Xlin = c("price", "x1", "x2", "x3", "x4", "x5"),
                        Xexo = c("x1", "x2", "x3", "x4", "x5"),
                        Xrandom = paste0("x",1:K),instruments = paste0("iv",1:10),
                        true.parameters = list(Xlin.true.except.price = rep(0.2,5),
                                               Xlin.true.price = -0.2,
                                               Xrandom.true = rep(2,K),
                                               instrument.effects = rep(2,10),
                                               instrument.Xexo.effects = rep(1,5)),
                        price.endogeneity = list( mean.xi = -2,
                                                  mean.eita = 0,
                                                  cov = cbind( c(1,0.7), c(0.7,1))),
                        printlevel = 0, seed = 234234 )


model <- as.formula("shares ~  price + x1 + x2 + x3 + x4 + x5 |
                    x1 + x2 + x3 + x4 + x5 |
                    0+ x1 + x2 |
                    iv1 + iv2 + iv3 + iv4 + iv5 + iv6 + iv7 + iv8 +iv9 +iv10" )

blp_data <- BLP_data(model = model, market_identifier="cdid",
                     product_id = "prod_id",
                     productData = data,
                     integration_method = "MLHS" ,
                     integration_accuracy = 40,
                     integration_seed = 1)

theta_guesses <- matrix(c(0.5,2), nrow=2)
rownames(theta_guesses) <- c("x1","x2")
colnames(theta_guesses) <- "unobs_sd"

blp_est <- estimateBLP(blp_data =blp_data,
                       par_theta2 = theta_guesses,
                       extremumCheck = FALSE ,
                       printLevel = 1 )
summary(blp_est)

}
