% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateBealModelFixedEffects.R
\encoding{UTF-8}
\name{simulateBealModelFixedEffects}
\alias{simulateBealModelFixedEffects}
\title{simulate data from Beal model with fixed effects}
\usage{
simulateBealModelFixedEffects(numSubjects, clearance, volumeOfDistribution,
  dose, timePoints)
}
\arguments{
\item{numSubjects}{scalar, number of subject which should be generated}

\item{clearance}{scalar, clearance}

\item{volumeOfDistribution}{scalar, volume of distribution}

\item{dose}{scalar, dose}

\item{timePoints}{vector of time points}
}
\value{
generated sample with numSubjects as the number of rows
and length of timePoints as the number of columns
}
\description{
function to generate data from a Beal model with fixed effects
}
\details{
The model used to generate data at time t is as follows 
\deqn{y(t)=C(t)\exp(e(t)),}
where \eqn{C(t)}, the PK-model, is defined as follows:
\deqn{C(t) = \frac{\mathrm{dose}}{V_d} \exp{(CL.t)},}
with \eqn{V_d} the volume of distribution and \eqn{CL} as clearance.
The error model is consdiered as \eqn{e(t) \sim N(0, h(t))}, with:
\deqn{h(t) = 0.03 + 0.165  \frac{C(t)^{-1}}{C(1.5)^{-1} + C(t)^{-1}}}
}
\examples{
set.seed(111)
simulateBealModelFixedEffects(10, 0.693,
 		1, 1, seq(0.5,3,0.5))
}
\seealso{
Beal S. L., Ways to fit a PK model with some data below 
the quantification limit, Journal of Pharmacokinetics
and Pharmacodynamics, 2001;28(\strong{5}):481–504.
}
\author{
Vahid Nassiri, Helen Yvette Barnett
}
