% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biodiversityFunctions.R
\name{recBySpp}
\alias{recBySpp}
\title{Observations by species or records-by-species matrix}
\usage{
recBySpp(x, format = "A", location = "coordinates")
}
\arguments{
\item{x}{an object of class \sQuote{OrganizedBirds} (organised BIRDS Spatial Dataframe).}

\item{format}{the type of matrix to return: type 'A' where each row is a
combination of species, location (unique coordinates or visits' ID) and count,
or 'B' where each row is a location, each column a species, and the elements
of the matrix the counts}

\item{location}{the uniqueness of the position given by the coordinates or the visits' ID}
}
\value{
a \code{data.frame} with a record-by-species matrix
}
\description{
This function prepares the organised data into a "records-by-species" matrix
summarizing the number of observations (records)  per species in the shape
required by the functions from the KnowBR package for calculating 'completeness'.
}
\examples{
\donttest{
grid <- makeGrid(searchPolygon, gridSize = 10)
OB <- organizeBirds(bombusObsShort, sppCol = "scientificName",
                    taxonRankCol = "taxonRank", taxonRank = "SPECIES",
                    simplifySppName = TRUE)
RxS <- recBySpp(OB)
}
}
\references{
Lobo et al. (2018) <https://doi.org/10.1016/j.ecolind.2018.03.077>
}
\seealso{
\code{\link{communityMatrix}}
}
