colclass <- structure(function#Column classes
### Column names of multilevel ecological data sets are grouped into
### three classes: \code{numeric}, time unit,
### or \code{factor}.
(
    rd, ##<<\code{data.frame}. Multilevel ecological data series.
    as.list = TRUE ##<<\code{logical}. List the classes. If
                   ##\code{TRUE} then column names of the data are grouped
                   ##in a list object.
) {
    
    tim <- c('second','hour','day','week',
             'month','year','time','millennium')
    
    n. <- sapply(rd,is.numeric)
    t. <- tim%in%names(rd)#;names(t.) <- tim
    tmp <- tim[t.]
    num <- names(n.)[n.]      
    fac <- names(n.)[!n.]
    num <- num[!num%in%tmp]
    fac <- fac[!fac%in%tmp]
    orv <- list(num = num,
                tmp = tmp, fac = fac)
    if(!as.list){
        orv <- c(orv, recursive = TRUE)
        names(orv) <- NULL}
    
    
    return(orv)
### \code{character} vector of the column names, or \code{list} of
### grouped column names.
} , ex=function() {
    ##Multilevel ecological data series of tree-ring widths:
    data(Prings05,envir = environment())
    ## getting grouped column names    
    classes <- colclass(Prings05)
    str(classes)
})
