// Generated by rstantools.  Do not edit by hand.

/*
    BINtools is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BINtools is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BINtools.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_case_4_M0_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_case_4_M0");
    reader.add_event(83, 81, "end", "model_case_4_M0");
    return reader;
}
template <typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__, typename T12__, typename T13__, typename T14__>
typename boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename boost::math::tools::promote_args<T11__, T12__, T13__, T14__>::type>::type>::type
information_diversity_probit_likelihood(const int& N_0,
                                            const int& N_1,
                                            const int& outcome,
                                            const T3__& M_0,
                                            const T4__& M_1,
                                            const T5__& V_0,
                                            const T6__& V_1,
                                            const T7__& C_0,
                                            const T8__& C_1,
                                            const T9__& C_01,
                                            const T10__& mu_star,
                                            const T11__& mu_0,
                                            const T12__& gamma_0,
                                            const T13__& rho_0,
                                            const T14__& v_0, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename boost::math::tools::promote_args<T11__, T12__, T13__, T14__>::type>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 6;
        local_scalar_t__ W(DUMMY_VAR__);
        (void) W;  // dummy to suppress unused var warning
        stan::math::initialize(W, DUMMY_VAR__);
        stan::math::fill(W, DUMMY_VAR__);
        stan::math::assign(W,(v_0 + ((N_0 - 1) * rho_0)));
        current_statement_begin__ = 7;
        local_scalar_t__ W_0(DUMMY_VAR__);
        (void) W_0;  // dummy to suppress unused var warning
        stan::math::initialize(W_0, DUMMY_VAR__);
        stan::math::fill(W_0, DUMMY_VAR__);
        stan::math::assign(W_0,(W * (rho_0 - v_0)));
        current_statement_begin__ = 10;
        local_scalar_t__ rho_0_i(DUMMY_VAR__);
        (void) rho_0_i;  // dummy to suppress unused var warning
        stan::math::initialize(rho_0_i, DUMMY_VAR__);
        stan::math::fill(rho_0_i, DUMMY_VAR__);
        stan::math::assign(rho_0_i,(rho_0 / W_0));
        current_statement_begin__ = 11;
        local_scalar_t__ delta_0_i(DUMMY_VAR__);
        (void) delta_0_i;  // dummy to suppress unused var warning
        stan::math::initialize(delta_0_i, DUMMY_VAR__);
        stan::math::fill(delta_0_i, DUMMY_VAR__);
        stan::math::assign(delta_0_i,((rho_0 - W) / W_0));
        current_statement_begin__ = 14;
        local_scalar_t__ logW(DUMMY_VAR__);
        (void) logW;  // dummy to suppress unused var warning
        stan::math::initialize(logW, DUMMY_VAR__);
        stan::math::fill(logW, DUMMY_VAR__);
        stan::math::assign(logW,stan::math::log(W));
        current_statement_begin__ = 15;
        local_scalar_t__ logdet(DUMMY_VAR__);
        (void) logdet;  // dummy to suppress unused var warning
        stan::math::initialize(logdet, DUMMY_VAR__);
        stan::math::fill(logdet, DUMMY_VAR__);
        stan::math::assign(logdet,(logW + ((N_0 - 1) * stan::math::log((v_0 - rho_0)))));
        current_statement_begin__ = 18;
        local_scalar_t__ cov_0(DUMMY_VAR__);
        (void) cov_0;  // dummy to suppress unused var warning
        stan::math::initialize(cov_0, DUMMY_VAR__);
        stan::math::fill(cov_0, DUMMY_VAR__);
        stan::math::assign(cov_0,(delta_0_i * ((V_0 - ((2 * mu_0) * M_0)) + (N_0 * pow(mu_0, 2)))));
        current_statement_begin__ = 19;
        local_scalar_t__ cov_00(DUMMY_VAR__);
        (void) cov_00;  // dummy to suppress unused var warning
        stan::math::initialize(cov_00, DUMMY_VAR__);
        stan::math::fill(cov_00, DUMMY_VAR__);
        stan::math::assign(cov_00,(rho_0_i * ((C_0 - (((2 * mu_0) * (N_0 - 1)) * M_0)) + ((N_0 * (N_0 - 1)) * pow(mu_0, 2)))));
        current_statement_begin__ = 20;
        local_scalar_t__ logcov(DUMMY_VAR__);
        (void) logcov;  // dummy to suppress unused var warning
        stan::math::initialize(logcov, DUMMY_VAR__);
        stan::math::fill(logcov, DUMMY_VAR__);
        stan::math::assign(logcov,(cov_0 + cov_00));
        current_statement_begin__ = 22;
        local_scalar_t__ D_0_i(DUMMY_VAR__);
        (void) D_0_i;  // dummy to suppress unused var warning
        stan::math::initialize(D_0_i, DUMMY_VAR__);
        stan::math::fill(D_0_i, DUMMY_VAR__);
        stan::math::assign(D_0_i,(delta_0_i + ((N_0 - 1) * rho_0_i)));
        current_statement_begin__ = 25;
        local_scalar_t__ mu_star_cond(DUMMY_VAR__);
        (void) mu_star_cond;  // dummy to suppress unused var warning
        stan::math::initialize(mu_star_cond, DUMMY_VAR__);
        stan::math::fill(mu_star_cond, DUMMY_VAR__);
        stan::math::assign(mu_star_cond,(mu_star + ((gamma_0 * D_0_i) * (M_0 - (N_0 * mu_0)))));
        current_statement_begin__ = 26;
        local_scalar_t__ ssq_star_cond(DUMMY_VAR__);
        (void) ssq_star_cond;  // dummy to suppress unused var warning
        stan::math::initialize(ssq_star_cond, DUMMY_VAR__);
        stan::math::fill(ssq_star_cond, DUMMY_VAR__);
        stan::math::assign(ssq_star_cond,(1 - ((N_0 * pow(gamma_0, 2)) * D_0_i)));
        current_statement_begin__ = 27;
        local_scalar_t__ sigma_star_cond(DUMMY_VAR__);
        (void) sigma_star_cond;  // dummy to suppress unused var warning
        stan::math::initialize(sigma_star_cond, DUMMY_VAR__);
        stan::math::fill(sigma_star_cond, DUMMY_VAR__);
        stan::math::assign(sigma_star_cond,stan::math::sqrt(ssq_star_cond));
        current_statement_begin__ = 28;
        local_scalar_t__ logprobit(DUMMY_VAR__);
        (void) logprobit;  // dummy to suppress unused var warning
        stan::math::initialize(logprobit, DUMMY_VAR__);
        stan::math::fill(logprobit, DUMMY_VAR__);
        stan::math::assign(logprobit,bernoulli_log(outcome, (1 - Phi((-(mu_star_cond) / sigma_star_cond)))));
        current_statement_begin__ = 32;
        return stan::math::promote_scalar<fun_return_scalar_t__>(((-(0.5) * ((logdet + logcov) + (N_0 * stan::math::log((2 * stan::math::pi()))))) + logprobit));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct information_diversity_probit_likelihood_functor__ {
    template <typename T3__, typename T4__, typename T5__, typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__, typename T12__, typename T13__, typename T14__>
        typename boost::math::tools::promote_args<T3__, T4__, T5__, T6__, typename boost::math::tools::promote_args<T7__, T8__, T9__, T10__, typename boost::math::tools::promote_args<T11__, T12__, T13__, T14__>::type>::type>::type
    operator()(const int& N_0,
                                            const int& N_1,
                                            const int& outcome,
                                            const T3__& M_0,
                                            const T4__& M_1,
                                            const T5__& V_0,
                                            const T6__& V_1,
                                            const T7__& C_0,
                                            const T8__& C_1,
                                            const T9__& C_01,
                                            const T10__& mu_star,
                                            const T11__& mu_0,
                                            const T12__& gamma_0,
                                            const T13__& rho_0,
                                            const T14__& v_0, std::ostream* pstream__) const {
        return information_diversity_probit_likelihood(N_0, N_1, outcome, M_0, M_1, V_0, V_1, C_0, C_1, C_01, mu_star, mu_0, gamma_0, rho_0, v_0, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_case_4_M0
  : public stan::model::model_base_crtp<model_case_4_M0> {
private:
        int N;
        std::vector<int> N_0;
        std::vector<int> N_1;
        std::vector<int> outcome;
        std::vector<double> M_0;
        std::vector<double> M_1;
        std::vector<double> V_0;
        std::vector<double> V_1;
        std::vector<double> C_0;
        std::vector<double> C_1;
        std::vector<double> C_01;
public:
    model_case_4_M0(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_case_4_M0(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_case_4_M0_namespace::model_case_4_M0";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 36;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 37;
            validate_non_negative_index("N_0", "N", N);
            context__.validate_dims("data initialization", "N_0", "int", context__.to_vec(N));
            N_0 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("N_0");
            pos__ = 0;
            size_t N_0_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < N_0_k_0_max__; ++k_0__) {
                N_0[k_0__] = vals_i__[pos__++];
            }
            size_t N_0_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < N_0_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "N_0[i_0__]", N_0[i_0__], 1);
            }
            current_statement_begin__ = 38;
            validate_non_negative_index("N_1", "N", N);
            context__.validate_dims("data initialization", "N_1", "int", context__.to_vec(N));
            N_1 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("N_1");
            pos__ = 0;
            size_t N_1_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < N_1_k_0_max__; ++k_0__) {
                N_1[k_0__] = vals_i__[pos__++];
            }
            size_t N_1_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < N_1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "N_1[i_0__]", N_1[i_0__], 0);
                check_less_or_equal(function__, "N_1[i_0__]", N_1[i_0__], 0);
            }
            current_statement_begin__ = 39;
            validate_non_negative_index("outcome", "N", N);
            context__.validate_dims("data initialization", "outcome", "int", context__.to_vec(N));
            outcome = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("outcome");
            pos__ = 0;
            size_t outcome_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < outcome_k_0_max__; ++k_0__) {
                outcome[k_0__] = vals_i__[pos__++];
            }
            size_t outcome_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < outcome_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "outcome[i_0__]", outcome[i_0__], 0);
                check_less_or_equal(function__, "outcome[i_0__]", outcome[i_0__], 1);
            }
            current_statement_begin__ = 40;
            validate_non_negative_index("M_0", "N", N);
            context__.validate_dims("data initialization", "M_0", "double", context__.to_vec(N));
            M_0 = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("M_0");
            pos__ = 0;
            size_t M_0_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < M_0_k_0_max__; ++k_0__) {
                M_0[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 41;
            validate_non_negative_index("M_1", "N", N);
            context__.validate_dims("data initialization", "M_1", "double", context__.to_vec(N));
            M_1 = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("M_1");
            pos__ = 0;
            size_t M_1_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < M_1_k_0_max__; ++k_0__) {
                M_1[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 42;
            validate_non_negative_index("V_0", "N", N);
            context__.validate_dims("data initialization", "V_0", "double", context__.to_vec(N));
            V_0 = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("V_0");
            pos__ = 0;
            size_t V_0_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < V_0_k_0_max__; ++k_0__) {
                V_0[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 43;
            validate_non_negative_index("V_1", "N", N);
            context__.validate_dims("data initialization", "V_1", "double", context__.to_vec(N));
            V_1 = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("V_1");
            pos__ = 0;
            size_t V_1_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < V_1_k_0_max__; ++k_0__) {
                V_1[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 44;
            validate_non_negative_index("C_0", "N", N);
            context__.validate_dims("data initialization", "C_0", "double", context__.to_vec(N));
            C_0 = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("C_0");
            pos__ = 0;
            size_t C_0_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < C_0_k_0_max__; ++k_0__) {
                C_0[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 45;
            validate_non_negative_index("C_1", "N", N);
            context__.validate_dims("data initialization", "C_1", "double", context__.to_vec(N));
            C_1 = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("C_1");
            pos__ = 0;
            size_t C_1_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < C_1_k_0_max__; ++k_0__) {
                C_1[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 46;
            validate_non_negative_index("C_01", "N", N);
            context__.validate_dims("data initialization", "C_01", "double", context__.to_vec(N));
            C_01 = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("C_01");
            pos__ = 0;
            size_t C_01_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < C_01_k_0_max__; ++k_0__) {
                C_01[k_0__] = vals_r__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 49;
            num_params_r__ += 1;
            current_statement_begin__ = 50;
            num_params_r__ += 1;
            current_statement_begin__ = 51;
            num_params_r__ += 1;
            current_statement_begin__ = 52;
            num_params_r__ += 1;
            current_statement_begin__ = 53;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_case_4_M0() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 49;
        if (!(context__.contains_r("mu_star")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_star missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_star");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_star", "double", context__.to_vec());
        double mu_star(0);
        mu_star = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu_star);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_star: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 50;
        if (!(context__.contains_r("mu_0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_0", "double", context__.to_vec());
        double mu_0(0);
        mu_0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu_0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 51;
        if (!(context__.contains_r("gamma_0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma_0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma_0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gamma_0", "double", context__.to_vec());
        double gamma_0(0);
        gamma_0 = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 1, gamma_0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma_0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 52;
        if (!(context__.contains_r("rho_0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho_0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho_0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "rho_0", "double", context__.to_vec());
        double rho_0(0);
        rho_0 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, rho_0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho_0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 53;
        if (!(context__.contains_r("delta_0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta_0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta_0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "delta_0", "double", context__.to_vec());
        double delta_0(0);
        delta_0 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, delta_0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta_0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 49;
            local_scalar_t__ mu_star;
            (void) mu_star;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_star = in__.scalar_constrain(lp__);
            else
                mu_star = in__.scalar_constrain();
            current_statement_begin__ = 50;
            local_scalar_t__ mu_0;
            (void) mu_0;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_0 = in__.scalar_constrain(lp__);
            else
                mu_0 = in__.scalar_constrain();
            current_statement_begin__ = 51;
            local_scalar_t__ gamma_0;
            (void) gamma_0;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma_0 = in__.scalar_lub_constrain(0, 1, lp__);
            else
                gamma_0 = in__.scalar_lub_constrain(0, 1);
            current_statement_begin__ = 52;
            local_scalar_t__ rho_0;
            (void) rho_0;  // dummy to suppress unused var warning
            if (jacobian__)
                rho_0 = in__.scalar_lb_constrain(0, lp__);
            else
                rho_0 = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 53;
            local_scalar_t__ delta_0;
            (void) delta_0;  // dummy to suppress unused var warning
            if (jacobian__)
                delta_0 = in__.scalar_lb_constrain(0, lp__);
            else
                delta_0 = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 56;
            local_scalar_t__ v_0;
            (void) v_0;  // dummy to suppress unused var warning
            stan::math::initialize(v_0, DUMMY_VAR__);
            stan::math::fill(v_0, DUMMY_VAR__);
            stan::math::assign(v_0,(gamma_0 + delta_0));
            current_statement_begin__ = 58;
            local_scalar_t__ bias_0;
            (void) bias_0;  // dummy to suppress unused var warning
            stan::math::initialize(bias_0, DUMMY_VAR__);
            stan::math::fill(bias_0, DUMMY_VAR__);
            stan::math::assign(bias_0,stan::math::fabs(mu_0));
            current_statement_begin__ = 60;
            local_scalar_t__ diff_bias;
            (void) diff_bias;  // dummy to suppress unused var warning
            stan::math::initialize(diff_bias, DUMMY_VAR__);
            stan::math::fill(diff_bias, DUMMY_VAR__);
            stan::math::assign(diff_bias,0);
            current_statement_begin__ = 61;
            local_scalar_t__ diff_info;
            (void) diff_info;  // dummy to suppress unused var warning
            stan::math::initialize(diff_info, DUMMY_VAR__);
            stan::math::fill(diff_info, DUMMY_VAR__);
            stan::math::assign(diff_info,0);
            current_statement_begin__ = 62;
            local_scalar_t__ diff_noise;
            (void) diff_noise;  // dummy to suppress unused var warning
            stan::math::initialize(diff_noise, DUMMY_VAR__);
            stan::math::fill(diff_noise, DUMMY_VAR__);
            stan::math::assign(diff_noise,0);
            current_statement_begin__ = 65;
            local_scalar_t__ sg0;
            (void) sg0;  // dummy to suppress unused var warning
            stan::math::initialize(sg0, DUMMY_VAR__);
            stan::math::fill(sg0, DUMMY_VAR__);
            stan::math::assign(sg0,stan::math::sqrt((1 - gamma_0)));
            current_statement_begin__ = 66;
            local_scalar_t__ g0;
            (void) g0;  // dummy to suppress unused var warning
            stan::math::initialize(g0, DUMMY_VAR__);
            stan::math::fill(g0, DUMMY_VAR__);
            stan::math::assign(g0,(1 - gamma_0));
            current_statement_begin__ = 68;
            local_scalar_t__ gamma_0_;
            (void) gamma_0_;  // dummy to suppress unused var warning
            stan::math::initialize(gamma_0_, DUMMY_VAR__);
            stan::math::fill(gamma_0_, DUMMY_VAR__);
            stan::math::assign(gamma_0_,(gamma_0 / sg0));
            current_statement_begin__ = 69;
            local_scalar_t__ v_0_;
            (void) v_0_;  // dummy to suppress unused var warning
            stan::math::initialize(v_0_, DUMMY_VAR__);
            stan::math::fill(v_0_, DUMMY_VAR__);
            stan::math::assign(v_0_,(v_0 / g0));
            current_statement_begin__ = 70;
            local_scalar_t__ rho_0_;
            (void) rho_0_;  // dummy to suppress unused var warning
            stan::math::initialize(rho_0_, DUMMY_VAR__);
            stan::math::fill(rho_0_, DUMMY_VAR__);
            stan::math::assign(rho_0_,(rho_0 / g0));
            current_statement_begin__ = 71;
            local_scalar_t__ mu_0_;
            (void) mu_0_;  // dummy to suppress unused var warning
            stan::math::initialize(mu_0_, DUMMY_VAR__);
            stan::math::fill(mu_0_, DUMMY_VAR__);
            stan::math::assign(mu_0_,((mu_star + mu_0) / sg0));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 56;
            if (stan::math::is_uninitialized(v_0)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: v_0";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable v_0: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 58;
            if (stan::math::is_uninitialized(bias_0)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: bias_0";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable bias_0: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 60;
            if (stan::math::is_uninitialized(diff_bias)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: diff_bias";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable diff_bias: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 61;
            if (stan::math::is_uninitialized(diff_info)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: diff_info";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable diff_info: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 62;
            if (stan::math::is_uninitialized(diff_noise)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: diff_noise";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable diff_noise: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 65;
            if (stan::math::is_uninitialized(sg0)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: sg0";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sg0: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 66;
            if (stan::math::is_uninitialized(g0)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: g0";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable g0: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 68;
            if (stan::math::is_uninitialized(gamma_0_)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: gamma_0_";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable gamma_0_: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 69;
            if (stan::math::is_uninitialized(v_0_)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: v_0_";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable v_0_: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 70;
            if (stan::math::is_uninitialized(rho_0_)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: rho_0_";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rho_0_: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            current_statement_begin__ = 71;
            if (stan::math::is_uninitialized(mu_0_)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu_0_";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu_0_: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            // model body
            current_statement_begin__ = 76;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 77;
                lp_accum__.add(information_diversity_probit_likelihood(get_base1(N_0, i, "N_0", 1), get_base1(N_1, i, "N_1", 1), get_base1(outcome, i, "outcome", 1), get_base1(M_0, i, "M_0", 1), get_base1(M_1, i, "M_1", 1), get_base1(V_0, i, "V_0", 1), get_base1(V_1, i, "V_1", 1), get_base1(C_0, i, "C_0", 1), get_base1(C_1, i, "C_1", 1), get_base1(C_01, i, "C_01", 1), mu_star, mu_0_, gamma_0_, rho_0_, v_0_, pstream__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_star");
        names__.push_back("mu_0");
        names__.push_back("gamma_0");
        names__.push_back("rho_0");
        names__.push_back("delta_0");
        names__.push_back("v_0");
        names__.push_back("bias_0");
        names__.push_back("diff_bias");
        names__.push_back("diff_info");
        names__.push_back("diff_noise");
        names__.push_back("sg0");
        names__.push_back("g0");
        names__.push_back("gamma_0_");
        names__.push_back("v_0_");
        names__.push_back("rho_0_");
        names__.push_back("mu_0_");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_case_4_M0_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double mu_star = in__.scalar_constrain();
        vars__.push_back(mu_star);
        double mu_0 = in__.scalar_constrain();
        vars__.push_back(mu_0);
        double gamma_0 = in__.scalar_lub_constrain(0, 1);
        vars__.push_back(gamma_0);
        double rho_0 = in__.scalar_lb_constrain(0);
        vars__.push_back(rho_0);
        double delta_0 = in__.scalar_lb_constrain(0);
        vars__.push_back(delta_0);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 56;
            double v_0;
            (void) v_0;  // dummy to suppress unused var warning
            stan::math::initialize(v_0, DUMMY_VAR__);
            stan::math::fill(v_0, DUMMY_VAR__);
            stan::math::assign(v_0,(gamma_0 + delta_0));
            current_statement_begin__ = 58;
            double bias_0;
            (void) bias_0;  // dummy to suppress unused var warning
            stan::math::initialize(bias_0, DUMMY_VAR__);
            stan::math::fill(bias_0, DUMMY_VAR__);
            stan::math::assign(bias_0,stan::math::fabs(mu_0));
            current_statement_begin__ = 60;
            double diff_bias;
            (void) diff_bias;  // dummy to suppress unused var warning
            stan::math::initialize(diff_bias, DUMMY_VAR__);
            stan::math::fill(diff_bias, DUMMY_VAR__);
            stan::math::assign(diff_bias,0);
            current_statement_begin__ = 61;
            double diff_info;
            (void) diff_info;  // dummy to suppress unused var warning
            stan::math::initialize(diff_info, DUMMY_VAR__);
            stan::math::fill(diff_info, DUMMY_VAR__);
            stan::math::assign(diff_info,0);
            current_statement_begin__ = 62;
            double diff_noise;
            (void) diff_noise;  // dummy to suppress unused var warning
            stan::math::initialize(diff_noise, DUMMY_VAR__);
            stan::math::fill(diff_noise, DUMMY_VAR__);
            stan::math::assign(diff_noise,0);
            current_statement_begin__ = 65;
            double sg0;
            (void) sg0;  // dummy to suppress unused var warning
            stan::math::initialize(sg0, DUMMY_VAR__);
            stan::math::fill(sg0, DUMMY_VAR__);
            stan::math::assign(sg0,stan::math::sqrt((1 - gamma_0)));
            current_statement_begin__ = 66;
            double g0;
            (void) g0;  // dummy to suppress unused var warning
            stan::math::initialize(g0, DUMMY_VAR__);
            stan::math::fill(g0, DUMMY_VAR__);
            stan::math::assign(g0,(1 - gamma_0));
            current_statement_begin__ = 68;
            double gamma_0_;
            (void) gamma_0_;  // dummy to suppress unused var warning
            stan::math::initialize(gamma_0_, DUMMY_VAR__);
            stan::math::fill(gamma_0_, DUMMY_VAR__);
            stan::math::assign(gamma_0_,(gamma_0 / sg0));
            current_statement_begin__ = 69;
            double v_0_;
            (void) v_0_;  // dummy to suppress unused var warning
            stan::math::initialize(v_0_, DUMMY_VAR__);
            stan::math::fill(v_0_, DUMMY_VAR__);
            stan::math::assign(v_0_,(v_0 / g0));
            current_statement_begin__ = 70;
            double rho_0_;
            (void) rho_0_;  // dummy to suppress unused var warning
            stan::math::initialize(rho_0_, DUMMY_VAR__);
            stan::math::fill(rho_0_, DUMMY_VAR__);
            stan::math::assign(rho_0_,(rho_0 / g0));
            current_statement_begin__ = 71;
            double mu_0_;
            (void) mu_0_;  // dummy to suppress unused var warning
            stan::math::initialize(mu_0_, DUMMY_VAR__);
            stan::math::fill(mu_0_, DUMMY_VAR__);
            stan::math::assign(mu_0_,((mu_star + mu_0) / sg0));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(v_0);
                vars__.push_back(bias_0);
                vars__.push_back(diff_bias);
                vars__.push_back(diff_info);
                vars__.push_back(diff_noise);
                vars__.push_back(sg0);
                vars__.push_back(g0);
                vars__.push_back(gamma_0_);
                vars__.push_back(v_0_);
                vars__.push_back(rho_0_);
                vars__.push_back(mu_0_);
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_case_4_M0";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_star";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma_0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "rho_0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta_0";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v_0";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "bias_0";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "diff_bias";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "diff_info";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "diff_noise";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "sg0";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "g0";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_0_";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "v_0_";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_0_";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_0_";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_star";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma_0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "rho_0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta_0";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v_0";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "bias_0";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "diff_bias";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "diff_info";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "diff_noise";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "sg0";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "g0";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_0_";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "v_0_";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho_0_";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_0_";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_case_4_M0_namespace::model_case_4_M0 stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
