% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_trait}
\alias{BIEN_trait_trait}
\title{Download all measurements of a specific trait(s).}
\usage{
BIEN_trait_trait(trait, print.query = FALSE, ...)
}
\arguments{
\item{trait}{A single trait or a vector of traits.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
A dataframe of all available trait data for the given trait(s).
}
\description{
BIEN_trait_trait downloads all measurements of the trait(s) specified.
}
\examples{
\dontrun{
BIEN_trait_trait("Height")
trait_vector<-c("Height", "Leaf dry mass")
BIEN_trait_trait(trait_vector)}
}
\seealso{
Other trait functions: \code{\link{BIEN_trait_family}},
  \code{\link{BIEN_trait_list}},
  \code{\link{BIEN_trait_mean}},
  \code{\link{BIEN_trait_species}},
  \code{\link{BIEN_trait_traitbyfamily}},
  \code{\link{BIEN_trait_traitbygenus}},
  \code{\link{BIEN_trait_traitbyspecies}},
  \code{\link{BIEN_trait_traits_per_species}}
}

