% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizePedigree.R
\name{summarizeMatrilines}
\alias{summarizeMatrilines}
\alias{summariseMatrilines}
\title{Summarize the maternal lines in a pedigree}
\usage{
summarizeMatrilines(
  ped,
  famID = "famID",
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  matID = "matID",
  patID = "patID",
  byr = NULL,
  include_founder = FALSE,
  founder_sort_var = NULL,
  nbiggest = 5,
  noldest = 5,
  skip_var = NULL,
  five_num_summary = FALSE,
  verbose = FALSE
)

summariseMatrilines(
  ped,
  famID = "famID",
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  matID = "matID",
  patID = "patID",
  byr = NULL,
  include_founder = FALSE,
  founder_sort_var = NULL,
  nbiggest = 5,
  noldest = 5,
  skip_var = NULL,
  five_num_summary = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{famID}{character.  Name of the column to be created in ped for the family ID variable}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}

\item{matID}{Character. Maternal line ID variable to be created and added to the pedigree}

\item{patID}{Character.  Paternal line ID variable to be created and added to the pedigree}

\item{byr}{Character. Optional column name for birth year. Used to determine the oldest lineages.}

\item{include_founder}{Logical. If `TRUE`, includes the founder (originating member) of each lineage in the output.}

\item{founder_sort_var}{Character. Column used to determine the founder of each lineage.
Defaults to `byr` (if available) or `personID` otherwise.}

\item{nbiggest}{Integer. Number of largest lineages to return (sorted by count).}

\item{noldest}{Integer. Number of oldest lineages to return (sorted by birth year).}

\item{skip_var}{Character vector. Variables to exclude from summary calculations.}

\item{five_num_summary}{Logical. If `TRUE`, includes the first quartile (Q1) and third quartile (Q3) in addition to
the minimum, median, and maximum values.}

\item{verbose}{Logical, if TRUE, print progress messages.}
}
\description{
Summarize the maternal lines in a pedigree
}
\seealso{
[summarizePedigrees ()]
}
